/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.shell;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.deviceconfig.service.DeviceConfigService;

@Command(scope="opennms", name="dcb-trigger", description="Trigger device config backup from a specific Interface")
@Service
public class DcbTriggerCommand
implements Action {
    @Reference
    private DeviceConfigService deviceConfigService;
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location = "Default";
    @Argument(index=0, name="host", description="Hostname or IP Address of the system to poll", required=true, multiValued=false)
    String host;
    @Option(name="-s", aliases={"--service"}, description="Device Config Service", required=false, multiValued=false)
    String service = "DeviceConfig";
    @Option(name="-p", aliases={"--persist"}, description="Whether to persist config or not")
    boolean persist = false;
    @Option(name="-v", aliases={"--verbose"}, description="See script output line-by-line", required=false, multiValued=false)
    boolean verbose = false;

    public Object execute() throws Exception {
        try {
            InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            System.out.printf("Not a valid host %s \n", this.host);
            return null;
        }
        CompletableFuture future = this.deviceConfigService.triggerConfigBackup(this.host, this.location, this.service, this.persist);
        while (true) {
            try {
                try {
                    DeviceConfigService.DeviceConfigBackupResponse response = (DeviceConfigService.DeviceConfigBackupResponse)future.get(1L, TimeUnit.SECONDS);
                    if (Strings.isNullOrEmpty((String)response.getErrorMessage())) {
                        System.out.printf("\nTriggered config backup for %s at location %s", this.host, this.location);
                        if (this.persist) {
                            System.out.println(" and persisted");
                        } else {
                            System.out.println();
                        }
                    } else {
                        System.err.println("Failed to trigger device config backup: " + response.getErrorMessage());
                    }
                    if (!this.verbose || Strings.isNullOrEmpty((String)response.getScriptOutput())) break;
                    System.out.printf("---SSH script output---\n%s\n----------end----------\n", response.getScriptOutput());
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted.");
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }
}

