/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.shell;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.deviceconfig.service.DeviceConfigService;
import org.opennms.features.deviceconfig.service.DeviceConfigUtil;
import org.opennms.netmgt.poller.DeviceConfig;

@Command(scope="opennms", name="dcb-get", description="Get device config backup from a specific Interface")
@Service
public class DcbGetCommand
implements Action {
    @Reference
    private DeviceConfigService deviceConfigService;
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location = "Default";
    @Argument(index=0, name="host", description="Hostname or IP Address of the system to poll", required=true, multiValued=false)
    String host;
    @Option(name="-s", aliases={"--service"}, description="Device Config Service", required=false, multiValued=false)
    String service = "DeviceConfig";
    @Option(name="-t", aliases={"--timeout"}, description="Timeout for device config retrieval in msec", required=false, multiValued=false)
    int timeout = 60000;
    @Option(name="-e", aliases={"--encoding"}, description="Encoding format", required=false, multiValued=false)
    String encoding = Charset.defaultCharset().name();
    @Option(name="-p", aliases={"--persist"}, description="Whether to persist config or not")
    boolean persist = false;

    public Object execute() throws Exception {
        try {
            InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            System.out.printf("Not a valid host %s \n", this.host);
            return null;
        }
        CompletableFuture future = this.deviceConfigService.getDeviceConfig(this.host, this.location, this.service, this.persist, this.timeout);
        while (true) {
            try {
                try {
                    DeviceConfig deviceConfig = (DeviceConfig)future.get(1L, TimeUnit.SECONDS);
                    if (deviceConfig.getContent() != null) {
                        byte[] content = deviceConfig.getContent();
                        if (DeviceConfigUtil.isGzipFile((String)deviceConfig.getFilename())) {
                            content = DeviceConfigUtil.decompressGzipToBytes((byte[])deviceConfig.getContent());
                        }
                        System.out.printf("Received file %s with content\u2026\n\n", deviceConfig.getFilename());
                        String config = new String(content, Charset.forName(this.encoding));
                        System.out.println(config);
                        break;
                    }
                    System.out.println("Device config not received.");
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted.");
                }
                catch (ExecutionException e) {
                    System.out.println("Failed to fetch device config: " + e.getMessage());
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }
}

