/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.kafka.subscriber;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.ipc.twin.api.TwinRequest;
import org.opennms.core.ipc.twin.api.TwinUpdate;
import org.opennms.core.ipc.twin.common.AbstractTwinSubscriber;
import org.opennms.core.ipc.twin.kafka.common.KafkaConsumerRunner;
import org.opennms.core.ipc.twin.kafka.common.Topic;
import org.opennms.core.ipc.twin.model.TwinRequestProto;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTwinSubscriber
extends AbstractTwinSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTwinSubscriber.class);
    private static final RateLimitedLog RATE_LIMITED_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private final KafkaConfigProvider kafkaConfigProvider;
    private KafkaProducer<String, byte[]> producer;
    private KafkaConsumerRunner consumer;

    public KafkaTwinSubscriber(MinionIdentity identity, KafkaConfigProvider kafkaConfigProvider, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        super((Identity)identity, tracerRegistry, metricRegistry);
        this.kafkaConfigProvider = Objects.requireNonNull(kafkaConfigProvider);
    }

    public void init() throws Exception {
        Properties kafkaConfig = new Properties();
        kafkaConfig.put("group.id", this.getIdentity().getId());
        kafkaConfig.put("enable.auto.commit", (Object)true);
        kafkaConfig.put("auto.commit.interval.ms", "1000");
        kafkaConfig.put("auto.offset.reset", "earliest");
        kafkaConfig.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        kafkaConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        kafkaConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
        kafkaConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
        kafkaConfig.putAll((Map<?, ?>)this.kafkaConfigProvider.getProperties());
        LOG.debug("Initialized kafka twin subscriber with {}", (Object)kafkaConfig);
        this.producer = (KafkaProducer)Utils.runWithGivenClassLoader(() -> new KafkaProducer(kafkaConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
        KafkaConsumer consumer = (KafkaConsumer)Utils.runWithGivenClassLoader(() -> new KafkaConsumer(kafkaConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
        consumer.subscribe((Collection)ImmutableList.builder().add((Object)Topic.responseForLocation((String)this.getIdentity().getLocation())).add((Object)Topic.responseGlobal()).build());
        this.consumer = new KafkaConsumerRunner(consumer, this::handleMessage, "twin-subscriber");
    }

    public void close() throws IOException {
        super.close();
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.producer != null) {
            this.producer.close();
        }
    }

    protected void sendRpcRequest(TwinRequest twinRequest) {
        try {
            TwinRequestProto twinRequestProto = this.mapTwinRequestToProto(twinRequest);
            ProducerRecord record = new ProducerRecord(Topic.request(), (Object)twinRequest.getKey(), (Object)twinRequestProto.toByteArray());
            this.producer.send(record, (meta, ex) -> {
                if (ex != null) {
                    RATE_LIMITED_LOG.error("Error sending request", (Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Exception while sending request with key {}", (Object)twinRequest.getKey());
        }
    }

    private void handleMessage(ConsumerRecord<String, byte[]> record) {
        try {
            TwinUpdate response = this.mapTwinResponseToProto((byte[])record.value());
            this.accept(response);
        }
        catch (Exception e) {
            LOG.error("Exception while processing twin update", (Throwable)e);
        }
    }
}

