/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf;

import java.awt.Color;
import org.opennms.shaded.jasper.com.lowagie.text.DocumentException;
import org.opennms.shaded.jasper.com.lowagie.text.ExceptionConverter;
import org.opennms.shaded.jasper.com.lowagie.text.Image;
import org.opennms.shaded.jasper.com.lowagie.text.Rectangle;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.ByteBuffer;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.ColumnText;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfContentByte;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPCell;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPCellEvent;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfPTable;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
        this.initExtraHeights();
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            if (pdfPRow.cells[i] == null) continue;
            this.cells[i] = new PdfPCell(pdfPRow.cells[i]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f = 0.0f;
        this.calculated = false;
        for (int i = 0; i < fArray.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) {
                f += fArray[i];
                continue;
            }
            pdfPCell.setLeft(f);
            int n = i + pdfPCell.getColspan();
            while (i < n) {
                f += fArray[i];
                ++i;
            }
            --i;
            pdfPCell.setRight(f);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        for (int i = 0; i < this.extraHeights.length; ++i) {
            this.extraHeights[i] = 0.0f;
        }
    }

    public void setExtraHeight(int n, float f) {
        if (n < 0 || n >= this.cells.length) {
            return;
        }
        this.extraHeights[n] = f;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i = 0; i < this.cells.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            float f = 0.0f;
            if (pdfPCell == null || !((f = pdfPCell.getMaxHeight()) > this.maxHeight) || pdfPCell.getRowspan() != 1) continue;
            this.maxHeight = f;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f, float f2, float f3, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        Color color = pdfPCell.getBackgroundColor();
        if (color != null || pdfPCell.hasBorders()) {
            Object object;
            float f4 = pdfPCell.getRight() + f;
            float f5 = pdfPCell.getTop() + f2;
            float f6 = pdfPCell.getLeft() + f;
            float f7 = f5 - f3;
            if (color != null) {
                object = pdfContentByteArray[1];
                ((PdfContentByte)object).setColorFill(color);
                ((PdfContentByte)object).rectangle(f6, f7, f4 - f6, f5 - f7);
                ((PdfContentByte)object).fill();
            }
            if (pdfPCell.hasBorders()) {
                object = new Rectangle(f6, f7, f4, f5);
                ((Rectangle)object).cloneNonPositionParameters(pdfPCell);
                ((Rectangle)object).setBackgroundColor(null);
                PdfContentByte pdfContentByte = pdfContentByteArray[2];
                pdfContentByte.rectangle((Rectangle)object);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f, float f2, float f3, float f4, float f5, float f6) {
        int n = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n * 2];
        }
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            this.canvasesPos[i * 2] = byteBuffer.size();
            pdfContentByteArray[i].saveState();
            pdfContentByteArray[i].concatCTM(f, f2, f3, f4, f5, f6);
            this.canvasesPos[i * 2 + 1] = byteBuffer.size();
        }
    }

    protected void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n = 4;
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            int n2 = byteBuffer.size();
            pdfContentByteArray[i].restoreState();
            if (n2 != this.canvasesPos[i * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i * 2]);
        }
    }

    public static float setColumn(ColumnText columnText, float f, float f2, float f3, float f4) {
        if (f > f3) {
            f3 = f;
        }
        if (f2 > f4) {
            f4 = f2;
        }
        columnText.setSimpleColumn(f, f2, f3, f4);
        return f4;
    }

    public void writeCells(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        n2 = n2 < 0 ? this.cells.length : Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            if (n3 <= 0) continue;
            f -= this.widths[n3 - 1];
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (this.cells[n3] != null) {
            f -= this.cells[n3].getLeft();
        }
        for (int i = n3; i < n2; ++i) {
            PdfPCellEvent pdfPCellEvent;
            float f3;
            float f4;
            float f5;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            float f6 = this.maxHeight + this.extraHeights[i];
            this.writeBorderAndBackground(f, f2, f6, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f7 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
            if (pdfPCell.getHeight() <= f6) {
                switch (pdfPCell.getVerticalAlignment()) {
                    case 6: {
                        f7 = pdfPCell.getTop() + f2 - f6 + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                    case 5: {
                        f7 = pdfPCell.getTop() + f2 + (pdfPCell.getHeight() - f6) / 2.0f - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.getHeight() > f6) {
                    image.scalePercent(100.0f);
                    f5 = (f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.getScaledHeight();
                    image.scalePercent(f5 * 100.0f);
                    bl = true;
                }
                f5 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 = f + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f5 = f + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth();
                            break;
                        }
                    }
                    f7 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f5, f7 - image.getScaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f8 = f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f5 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f8 + 0.001f, -f5);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f9 = -columnText.getYLine();
                if (f8 <= 0.0f || f5 <= 0.0f) {
                    f9 = 0.0f;
                }
                if (f9 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f9 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(-0.003f, -0.001f, f8 + 0.003f, f9);
                    if (pdfPCell.getRotation() == 90) {
                        f4 = pdfPCell.getTop() + f2 - f6 + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.getLeft() + f + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f9) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft() + f9;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f3, f4);
                    } else {
                        f4 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.getLeft() + f + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f9) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f9;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f3, f4);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f10 = pdfPCell.getFixedHeight();
                f5 = pdfPCell.getRight() + f - pdfPCell.getEffectivePaddingRight();
                float f11 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 += 10000.0f;
                            f11 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            if (pdfPCell.getRotation() == 180) {
                                f5 += 20000.0f;
                                break;
                            }
                            f11 -= 20000.0f;
                            break;
                        }
                        default: {
                            if (pdfPCell.getRotation() == 180) {
                                f11 -= 20000.0f;
                                break;
                            }
                            f5 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f3 = f7 - (f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f10 > 0.0f && pdfPCell.getHeight() > f6) {
                    f7 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                    f3 = pdfPCell.getTop() + f2 - f6 + pdfPCell.getEffectivePaddingBottom();
                }
                if ((f7 > f3 || columnText.zeroHeightElement()) && f11 < f5) {
                    columnText.setSimpleColumn(f11, f3 - 0.001f, f5, f7);
                    if (pdfPCell.getRotation() == 180) {
                        f4 = f11 + f5;
                        float f12 = f2 + f2 - f6 + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f4, f12);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            if ((pdfPCellEvent = pdfPCell.getCellEvent()) == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f, pdfPCell.getTop() + f2 - f6, pdfPCell.getRight() + f, pdfPCell.getTop() + f2);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f) {
        this.maxHeight = f;
    }

    float[] getEventWidth(float f) {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i].getWidth();
            ++n;
        }
        return fArray;
    }

    public PdfPRow splitRow(PdfPTable pdfPTable, int n, float f) {
        int n2;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length];
        float[] fArray2 = new float[this.cells.length];
        boolean bl = true;
        for (n2 = 0; n2 < this.cells.length; ++n2) {
            Object object;
            float f2 = f;
            PdfPCell pdfPCell = this.cells[n2];
            if (pdfPCell == null) {
                int n3 = n;
                if (!pdfPTable.rowSpanAbove(n3, n2)) continue;
                f2 += pdfPTable.getRowHeight(n3);
                while (pdfPTable.rowSpanAbove(--n3, n2)) {
                    f2 += pdfPTable.getRowHeight(n3);
                }
                object = pdfPTable.getRow(n3);
                if (object == null || ((PdfPRow)object).getCells()[n2] == null) continue;
                pdfPCellArray[n2] = new PdfPCell(((PdfPRow)object).getCells()[n2]);
                pdfPCellArray[n2].consumeHeight(f2);
                pdfPCellArray[n2].setRowspan(((PdfPRow)object).getCells()[n2].getRowspan() - n + n3);
                bl = false;
                continue;
            }
            fArray[n2] = pdfPCell.getFixedHeight();
            fArray2[n2] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            object = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f2 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    ((PdfPCell)object).setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n4;
                float f3;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f4 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                float f5 = pdfPCell.getTop() + pdfPCell.getEffectivePaddingBottom() - f2;
                float f6 = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                float f7 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                switch (pdfPCell.getRotation()) {
                    case 90: 
                    case 270: {
                        f3 = PdfPRow.setColumn(columnText, f5, f4, f7, f6);
                        break;
                    }
                    default: {
                        f3 = PdfPRow.setColumn(columnText, f4, f5, pdfPCell.isNoWrap() ? 20000.0f : f6, f7);
                    }
                }
                try {
                    n4 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f3;
                if (bl2) {
                    ((PdfPCell)object).setColumn(ColumnText.duplicate(pdfPCell.getColumn()));
                    columnText.setFilledWidth(0.0f);
                } else if ((n4 & 1) == 0) {
                    ((PdfPCell)object).setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    ((PdfPCell)object).setPhrase(null);
                }
                bl = bl && bl2;
            }
            pdfPCellArray[n2] = object;
            pdfPCell.setFixedHeight(f2);
        }
        if (bl) {
            for (n2 = 0; n2 < this.cells.length; ++n2) {
                PdfPCell pdfPCell = this.cells[n2];
                if (pdfPCell == null) continue;
                if (fArray[n2] > 0.0f) {
                    pdfPCell.setFixedHeight(fArray[n2]);
                    continue;
                }
                pdfPCell.setMinimumHeight(fArray2[n2]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

