/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.commands;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.events.commands.EventUeiCompleter;
import org.opennms.netmgt.xml.eventconf.Event;

@Command(scope="opennms", name="show-event-config", description="Renders the matched event definitions to XML. This command makes it possible to view event definitions which are not serialized on disk.")
@Service
public class EventConfigShowCommand
implements Action {
    @Reference
    public EventConfDao eventConfDao;
    @Option(name="-l", aliases={"--limit"}, description="Limit the number of event definitions that are shown.")
    int limit = 10;
    @Option(name="-u", aliases={"--uei"}, description="Event UEI substring to match.", required=true)
    @Completion(value=EventUeiCompleter.class)
    String eventUeiMatch;

    public Object execute() {
        Set matchedEventUeis = this.eventConfDao.getEventUEIs().stream().filter(uei -> uei.toLowerCase().contains(this.eventUeiMatch.toLowerCase())).sorted(Comparator.comparing(uei -> uei)).limit(this.limit).collect(Collectors.toSet());
        List matchedEvents = matchedEventUeis.stream().flatMap(uei -> this.eventConfDao.getEvents(uei).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        int count = 1;
        for (Event matched : matchedEvents) {
            String eventConfXml = JaxbUtils.marshal((Object)matched);
            System.out.printf("Event #%d\n", count);
            System.out.println(eventConfXml);
            System.out.println();
            ++count;
        }
        return null;
    }
}

