/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.eventforwarder.internal;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicallyTrackedProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(DynamicallyTrackedProcessor.class);
    private BundleContext m_context;
    private ServiceTracker<?, Processor> m_tracker = null;
    private String m_processorName;
    private String m_processorKey;

    public void process(Exchange exchange) throws Exception {
        if (this.m_tracker == null) {
            String filterString = String.format("(&(%s=%s)(name=%s)(%s=true))", "objectClass", Processor.class.getName(), this.m_processorName, this.m_processorKey);
            Filter filter = this.m_context.createFilter(filterString);
            LOG.info("Starting tracker with filter: {}", (Object)filterString);
            this.m_tracker = new ServiceTracker(this.m_context, filter, null);
            this.m_tracker.open();
        }
        try {
            Processor processor = (Processor)this.m_tracker.getService();
            if (processor == null) {
                throw new RuntimeException("No suitable processer was found.");
            }
            LOG.debug("Processing exchange with: {}", processor.getClass());
            processor.process(exchange);
        }
        catch (Throwable e) {
            LOG.warn("Message dispatch failed: " + e.getMessage(), e);
            exchange.setException(e);
        }
    }

    public void setContext(BundleContext context) {
        this.m_context = context;
    }

    public void setProcessorKey(String processorKey) {
        this.m_processorKey = processorKey;
    }

    public void setProcessorName(String processorName) {
        this.m_processorName = processorName;
    }

    public void destroy() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
    }
}

