/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.NativeSelect;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItemProvider;
import org.opennms.features.topology.api.info.item.DefaultInfoPanelItem;
import org.opennms.features.topology.api.info.item.InfoPanelItem;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SetStatusToCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.model.Status;

public class SimulationModeReductionKeyInfoPanelItemProvider
extends VertexInfoPanelItemProvider {
    private Component createComponent(ReductionKeyVertex vertex, GraphContainer container) {
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(false);
        formLayout.setMargin(false);
        NativeSelect dropdown = new NativeSelect("Severity");
        dropdown.setMultiSelect(false);
        dropdown.setNewItemsAllowed(false);
        dropdown.setNullSelectionAllowed(true);
        dropdown.setImmediate(true);
        dropdown.setRequired(true);
        dropdown.addItems(Arrays.asList(Status.values()));
        SetStatusToCriteria setStatusTo = SimulationModeReductionKeyInfoPanelItemProvider.findCriteria(container, vertex);
        if (setStatusTo != null) {
            dropdown.setValue((Object)setStatusTo.getStatus());
        } else {
            dropdown.setValue(null);
        }
        dropdown.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            SetStatusToCriteria currentSetStatusTo = SimulationModeReductionKeyInfoPanelItemProvider.findCriteria(container, vertex);
            Status selectedStatus = (Status)dropdown.getValue();
            SetStatusToCriteria newSetStatusTo = new SetStatusToCriteria(vertex.getReductionKey(), selectedStatus);
            if (currentSetStatusTo == null || !Objects.equals(selectedStatus, currentSetStatusTo.getStatus())) {
                if (currentSetStatusTo != null) {
                    container.removeCriteria((Criteria)currentSetStatusTo);
                }
                container.addCriteria((Criteria)newSetStatusTo);
            }
            container.getSelectionManager().setSelectedVertexRefs(Collections.emptyList());
            container.getSelectionManager().setSelectedEdgeRefs(Collections.emptyList());
            container.redoLayout();
        });
        formLayout.addComponent((Component)dropdown);
        return formLayout;
    }

    protected boolean contributeTo(VertexRef ref, GraphContainer container) {
        return ref instanceof ReductionKeyVertex && SimulationAwareStateMachineFactory.isInSimulationMode(container.getCriteria());
    }

    protected InfoPanelItem createInfoPanelItem(VertexRef ref, GraphContainer container) {
        return new DefaultInfoPanelItem().withOrder(0).withTitle("Simulate").withComponent(this.createComponent((ReductionKeyVertex)ref, container));
    }

    private static SetStatusToCriteria findCriteria(GraphContainer container, ReductionKeyVertex vertex) {
        for (SetStatusToCriteria set : container.findCriteria(SetStatusToCriteria.class)) {
            if (!vertex.getReductionKey().equals(set.getReductionKey())) continue;
            return set;
        }
        return null;
    }
}

