/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import java.util.Set;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class IpServiceVertex
extends AbstractBusinessServiceVertex {
    private final Integer ipServiceId;
    private final Set<String> reductionKeys;

    public IpServiceVertex(IpService ipService, int level) {
        this(ipService.getId(), ipService.getServiceName(), ipService.getIpAddress(), ipService.getReductionKeys(), ipService.getNodeId(), level);
    }

    public IpServiceVertex(GraphVertex graphVertex) {
        this(graphVertex.getIpService(), graphVertex.getLevel());
    }

    private IpServiceVertex(int ipServiceId, String ipServiceName, String ipAddress, Set<String> reductionKeys, int nodeId, int level) {
        super((Object)((Object)AbstractBusinessServiceVertex.Type.IpService) + ":" + ipServiceId, ipServiceName, level);
        this.ipServiceId = ipServiceId;
        this.reductionKeys = reductionKeys;
        this.setIpAddress(ipAddress);
        this.setLabel(ipServiceName);
        this.setTooltipText(String.format("IP Service '%s' on %s", ipServiceName, ipAddress));
        this.setIconKey("bsm.ip-service");
        this.setNodeID(nodeId);
    }

    public Integer getIpServiceId() {
        return this.ipServiceId;
    }

    @Override
    public AbstractBusinessServiceVertex.Type getType() {
        return AbstractBusinessServiceVertex.Type.IpService;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Set<String> getReductionKeys() {
        return this.reductionKeys;
    }

    @Override
    public <T> T accept(BusinessServiceVertexVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

