/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.reporting.availability.Category;

@XmlRootElement(name="categories")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Categories
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="category")
    private List<Category> categoryList = new ArrayList<Category>();

    public void addCategory(Category vCategory) throws IndexOutOfBoundsException {
        this.categoryList.add(vCategory);
    }

    public void addCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        this.categoryList.add(index, vCategory);
    }

    public Enumeration<Category> enumerateCategory() {
        return Collections.enumeration(this.categoryList);
    }

    public Category getCategory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.categoryList.size()) {
            throw new IndexOutOfBoundsException("getCategory: Index value '" + index + "' not in range [0.." + (this.categoryList.size() - 1) + "]");
        }
        return this.categoryList.get(index);
    }

    public Category[] getCategory() {
        Category[] array = new Category[]{};
        return this.categoryList.toArray(array);
    }

    public List<Category> getCategoryCollection() {
        return this.categoryList;
    }

    public int getCategoryCount() {
        return this.categoryList.size();
    }

    public Iterator<Category> iterateCategory() {
        return this.categoryList.iterator();
    }

    public void removeAllCategory() {
        this.categoryList.clear();
    }

    public boolean removeCategory(Category vCategory) {
        boolean removed = this.categoryList.remove(vCategory);
        return removed;
    }

    public Category removeCategoryAt(int index) {
        Category obj = this.categoryList.remove(index);
        return obj;
    }

    @Hidden
    public void setCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.categoryList.size()) {
            throw new IndexOutOfBoundsException("setCategory: Index value '" + index + "' not in range [0.." + (this.categoryList.size() - 1) + "]");
        }
        this.categoryList.set(index, vCategory);
    }

    @Hidden
    public void setCategory(Category[] vCategoryArray) {
        this.categoryList.clear();
        for (int i = 0; i < vCategoryArray.length; ++i) {
            this.categoryList.add(vCategoryArray[i]);
        }
    }

    public void setCategory(List<Category> vCategoryList) {
        this.categoryList.clear();
        this.categoryList.addAll(vCategoryList);
    }

    @Hidden
    public void setCategoryCollection(List<Category> categoryList) {
        this.categoryList = categoryList;
    }
}

