/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ops4j.io.FileUtils;
import org.ops4j.io.StreamUtils;

public class ZipExploder {
    protected boolean verbose;
    protected boolean sortNames;

    public ZipExploder() {
        this(false);
    }

    public ZipExploder(boolean verbose) {
        this.setVerbose(verbose);
    }

    public ZipExploder(boolean verbose, boolean sorted) {
        this(verbose);
        this.setSortNames(sorted);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean f) {
        this.verbose = f;
    }

    public boolean getSortNames() {
        return this.sortNames;
    }

    public void setSortNames(boolean sortNames) {
        this.sortNames = sortNames;
    }

    @Deprecated
    public void process(String[] zipNames, String[] jarNames, String destDir) throws IOException {
        this.process(FileUtils.pathNamesToFiles(zipNames), FileUtils.pathNamesToFiles(jarNames), new File(destDir));
    }

    public void process(File[] zipFiles, File[] jarFiles, File destDir) throws IOException {
        this.processZips(zipFiles, destDir);
        this.processJars(jarFiles, destDir);
    }

    @Deprecated
    public void processJars(String[] jarNames, String destDir) throws IOException {
        this.processJars(FileUtils.pathNamesToFiles(jarNames), new File(destDir));
    }

    public void processJars(File[] jarFiles, File destDir) throws IOException {
        for (int i = 0; i < jarFiles.length; ++i) {
            this.processFile(jarFiles[i], destDir);
        }
    }

    @Deprecated
    public void processZips(String[] zipNames, String destDir) throws IOException {
        this.processZips(FileUtils.pathNamesToFiles(zipNames), new File(destDir));
    }

    public void processZips(File[] zipFiles, File destDir) throws IOException {
        for (int i = 0; i < zipFiles.length; ++i) {
            this.processFile(zipFiles[i], destDir);
        }
    }

    @Deprecated
    public void processFile(String zipName, String destDir) throws IOException {
        this.processFile(new File(zipName), new File(destDir));
    }

    public void processFile(File zipFile, File destDir) throws IOException {
        if (!destDir.exists()) {
            throw new IOException("Destination directory '" + destDir + "' does not exist, or can't be read!");
        }
        ZipFile f = null;
        try {
            f = new ZipFile(zipFile);
            Map<String, ZipEntry> fEntries = this.getEntries(f);
            Object[] names = fEntries.keySet().toArray(new String[0]);
            if (this.sortNames) {
                Arrays.sort(names);
            }
            for (int i = 0; i < names.length; ++i) {
                Object name = names[i];
                ZipEntry e = fEntries.get(name);
                this.copyFileEntry(destDir, f, e);
            }
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg.indexOf(zipFile.toString()) < 0) {
                msg = msg + " - " + zipFile.toString();
            }
            throw new IOException(msg);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Map<String, ZipEntry> getEntries(ZipFile zf) {
        Enumeration<? extends ZipEntry> e = zf.entries();
        HashMap<String, ZipEntry> m = new HashMap<String, ZipEntry>();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            m.put(ze.getName(), ze);
        }
        return m;
    }

    @Deprecated
    public void copyFileEntry(String destDir, ZipFile zf, ZipEntry ze) throws IOException {
        this.copyFileEntry(new File(destDir), zf, ze);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileEntry(File destDir, ZipFile zf, ZipEntry ze) throws IOException {
        BufferedInputStream dis = new BufferedInputStream(zf.getInputStream(ze));
        try {
            this.copyFileEntry(destDir, ze.isDirectory(), ze.getName(), dis);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void copyFileEntry(File destDir, boolean destIsDir, String destFileName, InputStream dis) throws IOException {
        File dir;
        File outFile = new File(destDir, destFileName);
        if (!outFile.getCanonicalPath().startsWith(destDir.getCanonicalPath())) {
            throw new IOException("The output file is not contained in the destination directory");
        }
        File file = new File(destFileName);
        String parent = file.getParent();
        if (parent != null && parent.length() > 0 && (dir = new File(destDir, parent)) != null) {
            dir.mkdirs();
        }
        if (destIsDir) {
            outFile.mkdir();
        } else {
            StreamUtils.copyStream(dis, new FileOutputStream(outFile), true);
        }
    }

    protected void print(String s) {
        System.out.print(s);
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipExploder.class.getName() + " (-jar jarFilename... | -zip zipFilename...)... -dir destDir {-verbose}");
        System.out.println("Where:");
        System.out.println("  jarFilename path to source jar, may repeat");
        System.out.println("  zipFilename path to source zip, may repeat");
        System.out.println("  destDir    path to target directory; should exist");
        System.out.println("Note: one -jar or -zip is required; switch case or order is not important");
    }

    protected static void reportError(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ZipExploder.printHelp();
            System.exit(0);
        }
        ArrayList<String> zipNames = new ArrayList<String>();
        ArrayList<String> jarNames = new ArrayList<String>();
        String destDir = null;
        boolean jarActive = false;
        boolean zipActive = false;
        boolean destDirActive = false;
        boolean verbose = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if ((arg = arg.substring(1)).equalsIgnoreCase("jar")) {
                    jarActive = true;
                    zipActive = false;
                    destDirActive = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("zip")) {
                    zipActive = true;
                    jarActive = false;
                    destDirActive = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("dir")) {
                    jarActive = false;
                    zipActive = false;
                    destDirActive = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                    continue;
                }
                ZipExploder.reportError("Invalid switch - " + arg);
                continue;
            }
            if (jarActive) {
                jarNames.add(arg);
                continue;
            }
            if (zipActive) {
                zipNames.add(arg);
                continue;
            }
            if (destDirActive) {
                if (destDir != null) {
                    ZipExploder.reportError("duplicate argument - -destDir");
                }
                destDir = arg;
                continue;
            }
            ZipExploder.reportError("Too many parameters - " + arg);
        }
        if (destDir == null || zipNames.size() + jarNames.size() == 0) {
            ZipExploder.reportError("Missing parameters");
        }
        if (verbose) {
            System.out.println("Effective command: " + ZipExploder.class.getName() + " " + (jarNames.size() > 0 ? "-jars " + jarNames + " " : "") + (zipNames.size() > 0 ? "-zips " + zipNames + " " : "") + "-dir " + destDir);
        }
        try {
            ZipExploder ze = new ZipExploder(verbose);
            ze.process(FileUtils.pathNamesToFiles(zipNames.toArray(new String[zipNames.size()])), FileUtils.pathNamesToFiles(jarNames.toArray(new String[jarNames.size()])), new File(destDir));
        }
        catch (IOException ioe) {
            System.err.println("Exception - " + ioe.getMessage());
            ioe.printStackTrace();
            System.exit(2);
        }
    }
}

