/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.opennms.web.tags.select.SelectTagHandler;

public class SelectTag<T>
extends SimpleTagSupport {
    private static final String TEMPLATE = "<select id=\"favorite-select\" class=\"form-control\" {ONCHANGE}>\n{OPTIONS}\n</select>";
    private static final String OPTION_TEMPLATE = "<option value='{VALUE}' {SELECTED}>{DESCRIPTION}</option>\n";
    private List<T> m_elements;
    private T m_selected;
    private SelectTagHandler<T> m_selectTagHandler;
    private Comparator<T> m_comparator;
    private String m_onChange;
    private String m_defaultText = "";

    public void setDefaultText(String defaultStr) {
        this.m_defaultText = defaultStr;
    }

    public void setOnChange(String onChange) {
        this.m_onChange = onChange;
    }

    public void setElements(T[] elements) {
        ArrayList<T> elementsToAdd = new ArrayList<T>();
        for (T eachElement : elements) {
            elementsToAdd.add(eachElement);
        }
        this.setElements(elementsToAdd);
    }

    private void setElements(List<T> elements) {
        this.m_elements = new ArrayList<T>();
        if (elements == null) {
            return;
        }
        this.m_elements.addAll(elements);
    }

    public void setSelected(T selected) {
        this.m_selected = selected;
    }

    public void setHandler(SelectTagHandler<T> selectTagHandler) {
        this.m_selectTagHandler = selectTagHandler;
    }

    public void setComparator(Comparator<T> comparator) {
        this.m_comparator = comparator;
    }

    public void doTag() throws JspException, IOException {
        ArrayList<T> viewElements = new ArrayList<T>();
        if (this.m_elements != null) {
            viewElements.addAll(this.m_elements);
        }
        if (this.m_comparator != null) {
            Collections.sort(viewElements, this.m_comparator);
        }
        viewElements.add(0, null);
        StringBuilder optionsBuffer = new StringBuilder();
        for (Object eachElement : viewElements) {
            optionsBuffer.append(this.getOption(eachElement, this.m_selected));
        }
        String output = TEMPLATE.replace("{ONCHANGE}", (CharSequence)(StringUtils.isEmpty((String)this.m_onChange) ? "" : "onChange=\"" + this.m_onChange + "\"")).replace("{OPTIONS}", optionsBuffer.toString());
        this.getJspContext().getOut().write(output);
    }

    private String getOption(T element, T selected) {
        SelectTagHandler<T> handler = this.getSelectTagHandler();
        return OPTION_TEMPLATE.replace("{VALUE}", handler.getValue(element)).replace("{DESCRIPTION}", handler.getDescription(element)).replace("{SELECTED}", handler.isSelected(element, selected) ? "selected" : "");
    }

    private SelectTagHandler<T> getSelectTagHandler() {
        if (this.m_selectTagHandler == null) {
            DefaultSelectTagHandler defaultSelectTagHandler = new DefaultSelectTagHandler();
            defaultSelectTagHandler.setDefaultText(this.m_defaultText);
            return defaultSelectTagHandler;
        }
        return this.m_selectTagHandler;
    }

    private static class DefaultSelectTagHandler<T>
    implements SelectTagHandler<T> {
        private String m_defaultText = "";

        private DefaultSelectTagHandler() {
        }

        public void setDefaultText(String defaultStr) {
            this.m_defaultText = defaultStr;
        }

        @Override
        public String getValue(T input) {
            if (input == null) {
                return this.m_defaultText;
            }
            if (input instanceof String && StringUtils.isEmpty((String)((String)input))) {
                return this.m_defaultText;
            }
            return input.toString();
        }

        @Override
        public String getDescription(T input) {
            return this.getValue(input);
        }

        @Override
        public boolean isSelected(Object currentElement, Object selectedElement) {
            if (currentElement == selectedElement) {
                return true;
            }
            if (currentElement != null) {
                return currentElement.equals(selectedElement);
            }
            return false;
        }
    }
}

