/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SendEventController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(SendEventController.class);
    @Autowired
    private EventConfDao m_eventConfDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("/admin/sendevent", "model", this.createModel());
    }

    private Map<String, Object> createModel() throws FileNotFoundException, IOException {
        this.m_eventConfDao.reload();
        HashMap model = Maps.newHashMap();
        model.put("eventSelect", this.buildEventSelect());
        return model;
    }

    private String buildEventSelect() throws IOException, FileNotFoundException {
        List events = this.m_eventConfDao.getEventsByLabel();
        StringBuilder buffer = new StringBuilder();
        List<String> excludeList = this.getExcludeList();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (Event event : events) {
            String uei = event.getUei();
            String label = event.getEventLabel();
            String trimmedUei = this.stripUei(uei);
            if (excludeList.contains(trimmedUei)) continue;
            if (label != null && uei != null) {
                sortedMap.put(label, uei);
                continue;
            }
            LOG.warn("Event configuration with uei {} failed to validate, missing event label", (Object)event.getUei());
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            buffer.append("<option value=" + (String)entry.getValue() + ">" + (String)entry.getKey() + "</option>");
        }
        return buffer.toString();
    }

    private String stripUei(String uei) {
        String leftover = uei;
        for (int i = 0; i < 3; ++i) {
            leftover = leftover.substring(leftover.indexOf(47) + 1);
        }
        return leftover;
    }

    private List<String> getExcludeList() throws IOException, FileNotFoundException {
        ArrayList<String> excludes = new ArrayList<String>();
        Properties excludeProperties = new Properties();
        excludeProperties.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.EXCLUDE_UEI_FILE_NAME)));
        String[] ueis = BundleLists.parseBundleList((String)excludeProperties.getProperty("excludes"));
        for (int i = 0; i < ueis.length; ++i) {
            excludes.add(ueis[i]);
        }
        return excludes;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

