/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net.tcp.pool;

import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.graylog2.syslog4j.impl.pool.AbstractSyslogPoolFactory;
import org.graylog2.syslog4j.impl.pool.generic.GenericSyslogPoolFactory;

public class PooledTCPNetSyslog
extends TCPNetSyslog {
    private static final long serialVersionUID = 4279960451141784200L;
    protected AbstractSyslogPoolFactory poolFactory = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.poolFactory = this.createSyslogPoolFactory();
        this.poolFactory.initialize(this);
    }

    protected AbstractSyslogPoolFactory createSyslogPoolFactory() {
        GenericSyslogPoolFactory syslogPoolFactory = new GenericSyslogPoolFactory();
        return syslogPoolFactory;
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        try {
            AbstractSyslogWriter syslogWriter = this.poolFactory.borrowSyslogWriter();
            return syslogWriter;
        }
        catch (Exception e) {
            throw new SyslogRuntimeException(e);
        }
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
        try {
            this.poolFactory.returnSyslogWriter(syslogWriter);
        }
        catch (Exception e) {
            throw new SyslogRuntimeException(e);
        }
    }

    @Override
    public void flush() throws SyslogRuntimeException {
        try {
            this.poolFactory.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        try {
            this.poolFactory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

