/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.netmgt.threshd.api.ReinitializableState;
import org.opennms.netmgt.threshd.api.ThresholdStateMonitor;

public class BlobStoreAwareMonitor
implements ThresholdStateMonitor {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Map<String, ReinitializableState> stateMap = new ConcurrentHashMap<String, ReinitializableState>();
    private final BlobStore blobStore;

    public BlobStoreAwareMonitor(BlobStore blobStore) {
        this.blobStore = Objects.requireNonNull(blobStore);
    }

    public void trackState(String key, ReinitializableState state) {
        try {
            this.readLock.lock();
            this.stateMap.put(key, state);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void withReadLock(Runnable r) {
        try {
            this.readLock.lock();
            r.run();
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void withWriteLock(Consumer<Map<String, ReinitializableState>> stateConsumer) {
        try {
            this.writeLock.lock();
            stateConsumer.accept(this.stateMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reinitializeState(String stateKey) {
        this.withWriteLock(stateMap -> {
            ReinitializableState reinitializableState = (ReinitializableState)stateMap.get(stateKey);
            if (reinitializableState != null) {
                reinitializableState.reinitialize();
                this.clearSingleStateFromPersistence(stateKey);
                stateMap.remove(stateKey);
            }
        });
    }

    public void reinitializeStates() {
        this.withWriteLock(stateMap -> {
            if (!stateMap.isEmpty()) {
                stateMap.values().forEach(ReinitializableState::reinitialize);
                this.clearAllStatesFromPersistence();
                stateMap.clear();
            }
        });
    }

    private void clearSingleStateFromPersistence(String stateKey) {
        this.blobStore.delete(stateKey, "thresholding");
    }

    private void clearAllStatesFromPersistence() {
        this.blobStore.truncateContext("thresholding");
    }
}

