/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.integration.api.xml.ConfigUtils;

@XmlRootElement(name="script")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Script
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlValue
    private String m_content;
    @XmlAttribute(name="language", required=true)
    private String m_language;

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String content) {
        this.m_content = ConfigUtils.normalizeString(content);
        if (this.m_content != null) {
            this.m_content = this.m_content.intern();
        }
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = ConfigUtils.assertNotEmpty(language, "language").intern();
    }

    public int hashCode() {
        return Objects.hash(this.m_content, this.m_language);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Script) {
            Script that = (Script)obj;
            return Objects.equals(this.m_content, that.m_content) && Objects.equals(this.m_language, that.m_language);
        }
        return false;
    }

    public String toString() {
        return "Script [content=" + this.m_content + ", language=" + this.m_language + "]";
    }
}

