/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.prometheus;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.hawkular.agent.prometheus.text.TextPrometheusMetricsProcessor;
import org.hawkular.agent.prometheus.walkers.MetricCollectingWalker;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.netmgt.collection.api.ServiceParameters;

public class PrometheusScraper {
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final int DEFAULT_SO_TIMEOUT_MS = 10000;
    private static final String HEADER_PREFIX_PARM_KEY = "header-";
    public static final String DEFAULT_ACCEPT_HEADER = "application/openmetrics-text; version=0.0.1,text/plain;version=0.0.4;q=0.5,*/*;q=0.1";

    public static void scrape(URI uri, Map<String, Object> parameters, MetricCollectingWalker walker) throws IOException {
        try (HttpClientWrapper httpClientWrapper = PrometheusScraper.createHttpClientFromParmMap(parameters);){
            HttpGet get = new HttpGet(uri);
            get.setHeader("Accept", DEFAULT_ACCEPT_HEADER);
            parameters.forEach((k, v) -> {
                if (k.startsWith(HEADER_PREFIX_PARM_KEY) && v instanceof String) {
                    String headerName = k.substring(HEADER_PREFIX_PARM_KEY.length());
                    get.setHeader(headerName, (String)v);
                }
            });
            try (CloseableHttpResponse response = httpClientWrapper.execute((HttpUriRequest)get);){
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new IOException("No HTTP response entity from URL " + uri);
                }
                TextPrometheusMetricsProcessor processor = new TextPrometheusMetricsProcessor(entity.getContent(), walker);
                processor.walk();
            }
        }
    }

    public static HttpClientWrapper createHttpClientFromParmMap(Map<String, Object> parameters) {
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(parameters, (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)10000))).setSocketTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(parameters, (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)10000))).setRetries(Integer.valueOf(ParameterMap.getKeyedInteger(parameters, (String)ServiceParameters.ParameterName.RETRY.toString(), (int)2)));
        HttpClientWrapperConfigHelper.setUseSystemProxyIfDefined((HttpClientWrapper)clientWrapper, parameters);
        return clientWrapper;
    }
}

