/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.ua;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.sblim.slp.internal.msg.DADescriptor;

public class DACache {
    private static TreeMap cScopeMap = new TreeMap();

    public static synchronized List getDiscoverableScopeList(List pScopes) {
        if (pScopes == null || pScopes.size() == 0) {
            return null;
        }
        ArrayList<String> scopeList = null;
        Iterator itr = pScopes.iterator();
        while (itr.hasNext()) {
            String scope = (String)itr.next();
            ScopeEntry scopeEntry = (ScopeEntry)cScopeMap.get(scope);
            if (scopeEntry != null && scopeEntry.valid()) continue;
            if (scopeList == null) {
                scopeList = new ArrayList<String>();
            }
            scopeList.add(scope);
        }
        return scopeList;
    }

    public static synchronized List getDAList(List pScopes) {
        if (cScopeMap == null) {
            return null;
        }
        TreeSet<String> daSet = new TreeSet<String>();
        Iterator scopeItr = pScopes.iterator();
        while (scopeItr.hasNext()) {
            Iterator descItr;
            String scope = (String)scopeItr.next();
            ScopeEntry scopeEntry = (ScopeEntry)cScopeMap.get(scope);
            if (scopeEntry == null || (descItr = scopeEntry.getDADescriptorItr()) == null) continue;
            while (descItr.hasNext()) {
                daSet.add(((DADescriptor)descItr.next()).getURL());
            }
        }
        return new ArrayList(daSet);
    }

    public static synchronized void setDAList(List pScopes, List pDADescriptors) {
        if (pScopes == null || pDADescriptors == null) {
            return;
        }
        Iterator scopeItr = pScopes.iterator();
        while (scopeItr.hasNext()) {
            String scope = (String)scopeItr.next();
            TreeSet<DADescriptor> daDescsForScope = null;
            Iterator descItr = pDADescriptors.iterator();
            while (descItr.hasNext()) {
                DADescriptor daDesc = (DADescriptor)descItr.next();
                if (!daDesc.hasScope(scope)) continue;
                if (daDescsForScope == null) {
                    daDescsForScope = new TreeSet<DADescriptor>();
                }
                daDescsForScope.add(daDesc);
            }
            cScopeMap.put(scope, new ScopeEntry(daDescsForScope));
        }
    }

    static long getSecs() {
        return new Date().getTime() / 1000L;
    }

    private static class ScopeEntry {
        private long iTimeOfDiscovery;
        private TreeSet iDADescriptors;

        public ScopeEntry(TreeSet pDADescriptors) {
            this.iDADescriptors = pDADescriptors;
            this.iTimeOfDiscovery = DACache.getSecs();
        }

        public boolean valid() {
            return DACache.getSecs() - this.iTimeOfDiscovery <= 90L;
        }

        public Iterator getDADescriptorItr() {
            return this.iDADescriptors == null ? null : this.iDADescriptors.iterator();
        }
    }
}

