/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.pathoutage;

import com.google.common.collect.Lists;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.pathoutage.PathOutageStatusProvider;
import org.opennms.features.topology.plugins.topo.pathoutage.PathOutageVertex;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;

public class PathOutageProvider
extends AbstractTopologyProvider {
    public static final String NAMESPACE = "pathoutage";
    private NodeDao nodeDao;
    private PathOutageStatusProvider statusProvider;
    private DirectedSparseGraph<PathOutageVertex, AbstractEdge> sparseGraph;

    public PathOutageProvider(NodeDao nodeDao, PathOutageStatusProvider pathOutageStatusProvider) {
        super(NAMESPACE);
        this.nodeDao = nodeDao;
        this.statusProvider = pathOutageStatusProvider;
        this.sparseGraph = null;
    }

    public void refresh() {
        this.load();
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(0).withPreferredLayout("Hierarchy Layout").withCriteria(() -> {
            Map<VertexRef, Status> resultMap = this.statusProvider.getStatusForVertices(this.graph, Lists.newArrayList((Iterable)this.graph.getVertices(new Criteria[0])), new Criteria[0]);
            Optional<Map.Entry> max = resultMap.entrySet().stream().max(Comparator.comparing(e -> OnmsSeverity.get((String)((Status)e.getValue()).computeStatus())));
            if (max.isPresent()) {
                return Lists.newArrayList((Object[])new Criteria[]{new DefaultVertexHopCriteria((VertexRef)max.get().getKey())});
            }
            if (this.graph.getVertexTotalCount() > 0) {
                return Lists.newArrayList((Object[])new Criteria[]{new DefaultVertexHopCriteria((VertexRef)this.graph.getVertices(new Criteria[0]).get(0))});
            }
            return Lists.newArrayList();
        });
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        List nodeIds = selectedVertices.stream().filter(v -> NAMESPACE.equals(v.getNamespace())).filter(v -> v instanceof AbstractVertex).map(v -> (AbstractVertex)v).map(v -> v.getNodeID()).filter(id -> id != null).collect(Collectors.toList());
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return ContentType.Alarm == type || ContentType.Node == type;
    }

    private void load() {
        List nodes = this.nodeDao.findAll();
        this.sparseGraph = new DirectedSparseGraph();
        int edgeID = 0;
        for (OnmsNode node : nodes) {
            PathOutageVertex vertexChild = new PathOutageVertex(node);
            if (node.getParent() == null) {
                this.sparseGraph.addVertex((Object)vertexChild);
                continue;
            }
            PathOutageVertex vertexParent = new PathOutageVertex(node.getParent());
            vertexChild.setParent((VertexRef)vertexParent);
            this.sparseGraph.addVertex((Object)vertexChild);
            this.sparseGraph.addVertex((Object)vertexParent);
            this.sparseGraph.addEdge((Object)new AbstractEdge(NAMESPACE, String.valueOf(edgeID), (VertexRef)vertexParent, (VertexRef)vertexChild), (Object)vertexParent, (Object)vertexChild, EdgeType.DIRECTED);
            ++edgeID;
        }
        ArrayList<PathOutageVertex> tempVertices = new ArrayList<PathOutageVertex>();
        for (PathOutageVertex vertex : this.sparseGraph.getVertices()) {
            Collection predecessors = this.sparseGraph.getPredecessors((Object)vertex);
            if (!predecessors.isEmpty()) continue;
            vertex.setLevel(0);
            tempVertices.add(vertex);
            tempVertices.addAll(this.setLevel(this.sparseGraph, vertex, 1));
        }
        this.graph.resetContainer();
        for (PathOutageVertex customVertex : tempVertices) {
            this.graph.addVertices(new Vertex[]{customVertex});
        }
        for (AbstractEdge abstractEdge : this.sparseGraph.getEdges()) {
            this.graph.addEdges(new Edge[]{abstractEdge});
        }
    }

    private List<PathOutageVertex> setLevel(DirectedSparseGraph<PathOutageVertex, AbstractEdge> graph, PathOutageVertex vertex, int newLevel) {
        ArrayList<PathOutageVertex> result = new ArrayList<PathOutageVertex>();
        for (PathOutageVertex cVertex : graph.getSuccessors((Object)vertex)) {
            cVertex.setLevel(newLevel);
            result.add(cVertex);
            result.addAll(this.setLevel(graph, cVertex, newLevel + 1));
        }
        return result;
    }
}

