/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.collection.api.ResourceType;
import org.opennms.netmgt.collection.api.ResourceTypeMapper;
import org.opennms.netmgt.collection.dto.NodeLevelResourceDTO;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;

@XmlRootElement(name="generic-type-resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GenericTypeResourceDTO {
    @XmlElement(name="node-level-resource")
    private NodeLevelResourceDTO parent;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="fallback")
    private String fallback;
    @XmlAttribute(name="instance")
    private String instance;
    @XmlAttribute(name="timestamp")
    private Date timestamp;

    public GenericTypeResourceDTO() {
    }

    public GenericTypeResourceDTO(DeferredGenericTypeResource resource) {
        this.parent = new NodeLevelResourceDTO(resource.getParent());
        this.name = resource.getTypeName();
        this.fallback = resource.getFallbackTypeName();
        this.instance = resource.getInstance();
        this.timestamp = resource.getTimestamp();
    }

    public String toString() {
        return String.format("GenericTypeResourceDTO[parent=%s, name=%s, fallback=%s, instance=%s]", this.parent, this.name, this.fallback, this.instance);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.fallback, this.instance, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericTypeResourceDTO)) {
            return false;
        }
        GenericTypeResourceDTO other = (GenericTypeResourceDTO)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.name, other.name) && Objects.equals(this.fallback, other.fallback) && Objects.equals(this.instance, other.instance) && Objects.equals(this.timestamp, other.timestamp);
    }

    public GenericTypeResource toResource() {
        ResourceType resourceType = ResourceTypeMapper.getInstance().getResourceTypeWithFallback(this.name, this.fallback);
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("No resource type found with name '%s'!", this.name));
        }
        GenericTypeResource resource = new GenericTypeResource(this.parent.toResource(), resourceType, this.instance);
        resource.setTimestamp(this.timestamp);
        return resource;
    }
}

