/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.IpV4;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.IpV6;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleDatagram;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet4Header;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet6Header;

public class SampleDatagramEnricher {
    private final DnsResolver dnsResolver;
    private final boolean dnsLookupsEnabled;

    public SampleDatagramEnricher(DnsResolver dnsResolver, boolean dnsLookupsEnabled) {
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    public CompletableFuture<SampleDatagramEnrichment> enrich(SampleDatagram datagram) {
        if (!this.dnsLookupsEnabled) {
            CompletableFuture<SampleDatagramEnrichment> emptyFuture = new CompletableFuture<SampleDatagramEnrichment>();
            DefaultSampleDatagramEnrichment emptyEnrichment = new DefaultSampleDatagramEnrichment(Collections.emptyMap());
            emptyFuture.complete(emptyEnrichment);
            return emptyFuture;
        }
        final HashSet addressesToReverseLookup = new HashSet();
        datagram.visit(new SampleDatagramVisitor(){

            @Override
            public void accept(Inet4Header inet4Header) {
                addressesToReverseLookup.add(inet4Header.getSrcAddress());
                addressesToReverseLookup.add(inet4Header.getDstAddress());
            }

            @Override
            public void accept(Inet6Header inet6Header) {
                addressesToReverseLookup.add(inet6Header.getSrcAddress());
                addressesToReverseLookup.add(inet6Header.getDstAddress());
            }

            @Override
            public void accept(IpV4 ipV4) {
                addressesToReverseLookup.add(ipV4.getAddress());
            }

            @Override
            public void accept(IpV6 ipV6) {
                addressesToReverseLookup.add(ipV6.getAddress());
            }
        });
        HashMap hostnamesByAddress = new HashMap(addressesToReverseLookup.size());
        List<CompletableFuture> reverseLookupFutures = addressesToReverseLookup.stream().map(addr -> this.dnsResolver.reverseLookup(addr).whenComplete((hostname, ex) -> {
            if (ex == null) {
                Map map = hostnamesByAddress;
                synchronized (map) {
                    hostnamesByAddress.put(addr, hostname.orElse(null));
                }
            }
        })).collect(Collectors.toList());
        CompletableFuture<SampleDatagramEnrichment> future = new CompletableFuture<SampleDatagramEnrichment>();
        CompletableFuture.allOf(reverseLookupFutures.toArray(new CompletableFuture[0])).whenComplete((any, ex) -> {
            DefaultSampleDatagramEnrichment enrichment = new DefaultSampleDatagramEnrichment(hostnamesByAddress);
            future.complete(enrichment);
        });
        return future;
    }

    boolean isDnsLookupsEnabled() {
        return this.dnsLookupsEnabled;
    }

    private static class DefaultSampleDatagramEnrichment
    implements SampleDatagramEnrichment {
        private final Map<InetAddress, String> hostnamesByAddress;

        DefaultSampleDatagramEnrichment(Map<InetAddress, String> hostnamesByAddress) {
            this.hostnamesByAddress = hostnamesByAddress;
        }

        @Override
        public Optional<String> getHostnameFor(InetAddress address) {
            return Optional.ofNullable(this.hostnamesByAddress.get(address));
        }
    }
}

