/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.infocard.rp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.infocard.OpenIDTokenType;
import org.openid4java.message.ax.FetchRequest;

public class InfocardInvocation {
    private static Log _log = LogFactory.getLog(InfocardInvocation.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private OpenIDTokenType _tokenType;
    private List _requiredClaims = new ArrayList();
    private List _optionalClaims = new ArrayList();
    private String _issuer;
    private String _issuerPolicy;
    private String _privacyUrl;
    private int _privacyVersion;

    public InfocardInvocation(OpenIDTokenType tokenType) {
        this._requiredClaims.add("http://schema.openid.net/2007/05/claims/identifier");
        this._tokenType = tokenType;
        if (DEBUG) {
            _log.debug((Object)("Created " + this._tokenType + " token type InfocardInvocation"));
        }
    }

    public InfocardInvocation(FetchRequest fetch) {
        this._requiredClaims.add("http://schema.openid.net/2007/05/claims/identifier");
        this._tokenType = OpenIDTokenType.OPENID20_TOKEN;
        this._requiredClaims.addAll(fetch.getAttributes(true).values());
        this._optionalClaims.addAll(fetch.getAttributes(false).values());
        if (DEBUG) {
            _log.debug((Object)("Created " + this._tokenType + " token type InfocardInvocation from a FetchRequest."));
        }
    }

    public OpenIDTokenType getTokenType() {
        return this._tokenType;
    }

    public void setTokenType(OpenIDTokenType tokenType) {
        this._tokenType = tokenType;
    }

    public List getClaims(boolean required) {
        return required ? this._requiredClaims : this._optionalClaims;
    }

    public void addClaim(String claim, boolean required) {
        if (required && !this._requiredClaims.contains(claim)) {
            this._requiredClaims.add(claim);
        } else if (!this._optionalClaims.contains(claim)) {
            this._optionalClaims.add(claim);
        }
    }

    public void setClaims(List claims, boolean required) {
        if (required) {
            this._requiredClaims = claims;
            if (!this._requiredClaims.contains("http://schema.openid.net/2007/05/claims/identifier")) {
                this._requiredClaims.add("http://schema.openid.net/2007/05/claims/identifier");
            }
        } else {
            this._optionalClaims = claims;
        }
    }

    public String getIssuer() {
        return this._issuer;
    }

    public void setIssuer(String issuer) {
        this._issuer = issuer;
    }

    public String getIssuerPolicy() {
        return this._issuerPolicy;
    }

    public void setIssuerPolicy(String issuerPolicy) {
        this._issuerPolicy = issuerPolicy;
    }

    public String getPrivacyUrl() {
        return this._privacyUrl;
    }

    public int getPrivacyVersion() {
        return this._privacyVersion;
    }

    public void setPrivacyData(String url, int version) {
        this._privacyUrl = url;
        this._privacyVersion = version;
    }

    public String getHtmlObject() {
        StringBuffer object = new StringBuffer();
        object.append("<OBJECT type=\"application/x-informationCard\" name=\"xmlToken\">");
        object.append(this.getObjectParam("tokenType", this._tokenType.toString()));
        object.append(this.getObjectParam("requiredClaims", this.arrayToString(this._requiredClaims)));
        if (this._optionalClaims.size() > 0) {
            object.append(this.getObjectParam("optionslClaims", this.arrayToString(this._optionalClaims)));
        }
        if (this._issuer != null && this._issuer.length() > 0) {
            object.append(this.getObjectParam("issuer", this._issuer));
        }
        if (this._issuerPolicy != null && this._issuerPolicy.length() > 0) {
            object.append(this.getObjectParam("issuerPolicy", this._issuerPolicy));
        }
        if (this._privacyUrl != null && this._privacyUrl.length() > 0) {
            object.append(this.getObjectParam("privacyUrl", this._privacyUrl));
            object.append(this.getObjectParam("privacyVersion", Integer.toString(this._privacyVersion)));
        }
        if (DEBUG) {
            _log.debug((Object)("Generated <object> element: " + object));
        }
        return object.toString();
    }

    public String getXhtml() {
        StringBuffer xhtml = new StringBuffer();
        if (DEBUG) {
            _log.debug((Object)("Generated XHTML invocation snippet: " + xhtml));
        }
        throw new UnsupportedOperationException("XHTML invocation not implemented");
    }

    public String getObjectParam(String paramName, String paramValue) {
        StringBuffer param = new StringBuffer();
        param.append("<PARAM Name=\"").append(paramName).append("\"");
        param.append(" Value=\"").append(paramValue).append("\"");
        return param.toString();
    }

    public String arrayToString(List list) {
        StringBuffer result = new StringBuffer();
        if (list != null && list.size() > 0) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
                result.append(" ");
            }
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

