/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.input;

import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.EntityHelper;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.BaseValueTransformer;
import com.atlassian.jira.rest.client.api.domain.input.CannotTransformValueException;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.PropertyInput;
import com.atlassian.jira.rest.client.api.domain.input.ValueTransformerManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class IssueInputBuilder {
    private static final DateTimeFormatter JIRA_DATE_FORMATTER = ISODateTimeFormat.date();
    private final ValueTransformerManager valueTransformerManager = new ValueTransformerManager().registerTransformer(new BaseValueTransformer());
    private Map<String, FieldInput> fields = Maps.newHashMap();
    private final List<PropertyInput> properties = new ArrayList<PropertyInput>();

    public IssueInputBuilder() {
    }

    public IssueInputBuilder(String projectKey, Long issueTypeId) {
        this.setProjectKey(projectKey);
        this.setIssueTypeId(issueTypeId);
    }

    public IssueInputBuilder(BasicProject project, IssueType issueType) {
        this.setProject(project);
        this.setIssueType(issueType);
    }

    public IssueInputBuilder(String projectKey, Long issueTypeId, String summary) {
        this(projectKey, issueTypeId);
        this.setSummary(summary);
    }

    public IssueInputBuilder(BasicProject project, IssueType issueType, String summary) {
        this(project, issueType);
        this.setSummary(summary);
    }

    public IssueInputBuilder setSummary(String summary) {
        return this.setFieldInput(new FieldInput(IssueFieldId.SUMMARY_FIELD, (Object)summary));
    }

    public IssueInputBuilder setProjectKey(String projectKey) {
        return this.setFieldInput(new FieldInput(IssueFieldId.PROJECT_FIELD, (Object)ComplexIssueInputFieldValue.with("key", projectKey)));
    }

    public IssueInputBuilder setProject(BasicProject project) {
        return this.setProjectKey(project.getKey());
    }

    public IssueInputBuilder setIssueTypeId(Long issueTypeId) {
        return this.setFieldInput(new FieldInput(IssueFieldId.ISSUE_TYPE_FIELD, (Object)ComplexIssueInputFieldValue.with("id", issueTypeId.toString())));
    }

    public IssueInputBuilder setIssueType(IssueType issueType) {
        return this.setIssueTypeId(issueType.getId());
    }

    public IssueInputBuilder setFieldInput(FieldInput fieldInput) {
        this.fields.put(fieldInput.getId(), fieldInput);
        return this;
    }

    public IssueInputBuilder setFieldValue(String id, ComplexIssueInputFieldValue value) {
        return this.setFieldInput(new FieldInput(id, (Object)value));
    }

    public IssueInputBuilder setFieldValue(String id, Object value) throws CannotTransformValueException {
        return this.setFieldInput(new FieldInput(id, this.valueTransformerManager.apply(value)));
    }

    public IssueInputBuilder setDescription(String summary) {
        return this.setFieldInput(new FieldInput(IssueFieldId.DESCRIPTION_FIELD, (Object)summary));
    }

    public IssueInputBuilder setAssignee(BasicUser assignee) {
        return this.setAssigneeName(assignee.getName());
    }

    public IssueInputBuilder setAssigneeName(String assignee) {
        return this.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with("name", assignee)));
    }

    public IssueInput build() {
        return new IssueInput(this.fields, this.properties);
    }

    public IssueInputBuilder setAffectedVersions(Iterable<Version> versions) {
        return this.setAffectedVersionsNames(EntityHelper.toNamesList(versions));
    }

    public IssueInputBuilder setAffectedVersionsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.AFFECTS_VERSIONS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setComponentsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.COMPONENTS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setComponents(Iterable<BasicComponent> basicComponents) {
        return this.setComponentsNames(EntityHelper.toNamesList(basicComponents));
    }

    public IssueInputBuilder setComponents(BasicComponent ... basicComponents) {
        return this.setComponents(Lists.newArrayList(basicComponents));
    }

    public IssueInputBuilder setDueDate(DateTime date) {
        return this.setFieldInput(new FieldInput(IssueFieldId.DUE_DATE_FIELD, (Object)JIRA_DATE_FORMATTER.print((ReadableInstant)date)));
    }

    public IssueInputBuilder setFixVersionsNames(Iterable<String> names) {
        return this.setFieldInput(new FieldInput(IssueFieldId.FIX_VERSIONS_FIELD, this.toListOfComplexIssueInputFieldValueWithSingleKey(names, "name")));
    }

    public IssueInputBuilder setFixVersions(Iterable<Version> versions) {
        return this.setFixVersionsNames(EntityHelper.toNamesList(versions));
    }

    public IssueInputBuilder setPriority(BasicPriority priority) {
        return this.setPriorityId(priority.getId());
    }

    public IssueInputBuilder setPriorityId(Long id) {
        return this.setFieldInput(new FieldInput(IssueFieldId.PRIORITY_FIELD, (Object)ComplexIssueInputFieldValue.with("id", id.toString())));
    }

    public IssueInputBuilder setReporter(BasicUser reporter) {
        return this.setReporterName(reporter.getName());
    }

    public IssueInputBuilder setReporterName(String reporterName) {
        return this.setFieldInput(new FieldInput(IssueFieldId.REPORTER_FIELD, (Object)ComplexIssueInputFieldValue.with("name", reporterName)));
    }

    public IssueInputBuilder addProperty(String key, String value) {
        this.properties.add(new PropertyInput(key, value));
        return this;
    }

    public ValueTransformerManager getValueTransformerManager() {
        return this.valueTransformerManager;
    }

    private <T> Iterable<ComplexIssueInputFieldValue> toListOfComplexIssueInputFieldValueWithSingleKey(Iterable<T> items, final String key) {
        return Iterables.transform(items, new Function<T, ComplexIssueInputFieldValue>(){

            @Override
            public ComplexIssueInputFieldValue apply(T value) {
                return ComplexIssueInputFieldValue.with(key, value);
            }
        });
    }
}

