/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.sshscripting;

import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public interface SshScriptingService {
    public Result execute(String var1, String var2, String var3, String var4, SocketAddress var5, String var6, String var7, Map<String, String> var8, Duration var9);

    public String getScriptOutput();

    public static class Result {
        public final String message;
        public final Optional<String> stdout;
        public final Optional<String> stderr;
        public final boolean success;
        public final String scriptOutput;

        private Result(boolean success, String message, Optional<String> stdout, Optional<String> stderr, String scriptOutput) {
            this.success = success;
            this.message = message;
            this.stdout = stdout;
            this.stderr = stderr;
            this.scriptOutput = scriptOutput;
        }

        public static Result success(String message, String stdout, String stderr, String scriptOutput) {
            return new Result(true, message, Optional.of(stdout), Optional.of(stderr), scriptOutput);
        }

        public static Result success(String message, String stdout, String stderr) {
            return new Result(true, message, Optional.of(stdout), Optional.of(stderr), "");
        }

        public static Result success(String message) {
            return new Result(true, message, Optional.empty(), Optional.empty(), "");
        }

        public static Result failure(String message, String stdout, String stderr, String scriptOutput) {
            return new Result(false, message, Optional.of(stdout), Optional.of(stderr), scriptOutput);
        }

        public static Result failure(String message, String stdout, String stderr) {
            return new Result(false, message, Optional.of(stdout), Optional.of(stderr), "");
        }

        public static Result failure(String message) {
            return new Result(false, message, Optional.empty(), Optional.empty(), "");
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isFailed() {
            return !this.success;
        }
    }
}

