/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.ensemble.fixed;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.ensemble.EnsembleProvider;

public class FixedEnsembleProvider
implements EnsembleProvider {
    private final AtomicReference<String> connectionString = new AtomicReference();
    private final boolean updateServerListEnabled;

    public FixedEnsembleProvider(String connectionString) {
        this(connectionString, true);
    }

    public FixedEnsembleProvider(String connectionString, boolean updateServerListEnabled) {
        this.updateServerListEnabled = updateServerListEnabled;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connectionString) ? 1 : 0) != 0, (Object)"connectionString cannot be null or empty");
        this.connectionString.set(connectionString);
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.connectionString.set(connectionString);
    }

    @Override
    public String getConnectionString() {
        return this.connectionString.get();
    }

    @Override
    public boolean updateServerListEnabled() {
        return this.updateServerListEnabled;
    }
}

