/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change.types;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import liquibase.ext2.cm.change.types.AbstractPropertyType;
import liquibase.parser.core.ParsedNode;
import org.opennms.features.config.dao.api.ConfigItem;

public class NumberType
extends AbstractPropertyType {
    public NumberType(List<ParsedNode> listOfAttributes) {
        super(listOfAttributes);
        this.configItem.setType(ConfigItem.Type.NUMBER);
        Double defaultValue = this.defaultValueOpt.map(this::validateNumber).map(Double::valueOf).orElse(null);
        this.configItem.setDefaultValue((Object)defaultValue);
        Optional<String> min = this.getAttributeValue("min").map(this::validateNumber);
        Optional<String> max = this.getAttributeValue("max").map(this::validateNumber);
        double minP = min.map(Double::parseDouble).orElse((Double)Double.MIN_VALUE);
        double maxP = max.map(Double::parseDouble).orElse((Double)Double.MAX_VALUE);
        if (maxP < minP) {
            throw new IllegalArgumentException(String.format("min=%s must not be bigger than max=%s", minP, maxP));
        }
        if (defaultValue != null) {
            if (min.isPresent() && defaultValue < minP) {
                throw new IllegalArgumentException(String.format("defaultValue=%s must not be smaller than min=%s", defaultValue, min.get()));
            }
            if (max.isPresent() && defaultValue > maxP) {
                throw new IllegalArgumentException(String.format("defaultValue=%s must not be bigger than max=%s", defaultValue, max.get()));
            }
        }
    }

    private String validateNumber(String number) {
        Objects.requireNonNull(number);
        try {
            Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse value as 'number': %s. %s", number, e.getMessage()));
        }
        return number;
    }
}

