/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext2.cm.change.AbstractCmChange;
import liquibase.ext2.cm.change.ConfigFileUtil;
import liquibase.ext2.cm.change.ImportConfigurationUtil;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.statement.GenericCmStatement;
import liquibase.statement.SqlStatement;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@DatabaseChange(name="importConfig", description="Imports a configuration from file.", priority=5)
public class ImportConfiguration
extends AbstractCmChange {
    private static final Logger LOG = LoggerFactory.getLogger(ImportConfiguration.class);
    private static final Set<String> ALLOWED_EXTENSIONS = Set.of("xml", "cfg");
    private String schemaId;
    private String configId;
    private String filePath;
    private Path archivePath;
    private Resource configResource;

    @Override
    public ValidationErrors validate(CmDatabase db, ValidationErrors validationErrors) {
        validationErrors.checkRequiredField("schemaId", (Object)this.schemaId);
        validationErrors.checkRequiredField("filePath", (Object)this.filePath);
        Optional<Resource> configResource = ConfigFileUtil.findConfigFiles(this.filePath).stream().findAny();
        if (configResource.isEmpty() || !configResource.get().isReadable()) {
            validationErrors.addError(String.format("Can not read configuration in file: %s/etc/%s or in classpath: /defaults/%s", ConfigFileUtil.OPENNMS_HOME, this.filePath, this.filePath));
        } else {
            this.configResource = configResource.get();
        }
        this.archivePath = ConfigFileUtil.validateAndGetArchiveDir(validationErrors);
        ConfigFileUtil.checkFileType(validationErrors, ALLOWED_EXTENSIONS, this.filePath);
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return String.format("Imported configuration from %s with id=%s for schema=%s", this.filePath, this.getConfigId(), this.schemaId);
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new GenericCmStatement(cm -> ImportConfigurationUtil.importConfig(cm, this.configResource, new ConfigUpdateInfo(this.schemaId, this.getConfigId()), this.archivePath))};
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public String getConfigId() {
        return this.configId == null ? "default" : this.configId;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

