/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.uiextension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.apilayer.uiextension.UIExtensionRegistry;
import org.opennms.integration.api.v1.ui.UIExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIExtensionRegistryImpl
implements UIExtensionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UIExtensionRegistryImpl.class);
    private final Map<String, UIExtension> extensionMap = new HashMap<String, UIExtension>();

    public synchronized void onBind(UIExtension extension, Map properties) {
        LOG.debug("Extension registry bind called with {}: {}", (Object)extension, (Object)properties);
        if (extension != null) {
            this.extensionMap.put(extension.getExtensionId(), extension);
        }
    }

    public synchronized void onUnbind(UIExtension extension, Map properties) {
        LOG.debug("Extension registry unBind called with {}: {}", (Object)extension, (Object)properties);
        if (extension != null) {
            this.extensionMap.remove(extension.getExtensionId());
        }
    }

    @Override
    public Set<String> getExtensionNames() {
        return this.extensionMap.keySet();
    }

    @Override
    public UIExtension getExtensionByID(String id) {
        return this.extensionMap.get(id);
    }

    @Override
    public List<UIExtension> listExtensions() {
        return new ArrayList<UIExtension>(this.extensionMap.values());
    }
}

