/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.ticketing;

import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.features.apilayer.common.utils.InterfaceMapper;
import org.opennms.features.apilayer.ticketing.TicketingMapper;
import org.opennms.integration.api.v1.ticketing.TicketingPlugin;
import org.osgi.framework.BundleContext;

public class TicketingPluginManager
extends InterfaceMapper<TicketingPlugin, Plugin> {
    public TicketingPluginManager(BundleContext bundleContext) {
        super(Plugin.class, bundleContext);
    }

    public Plugin map(final TicketingPlugin ext) {
        return new Plugin(){

            public Ticket get(String ticketId) throws PluginException {
                try {
                    org.opennms.integration.api.v1.ticketing.Ticket ticket = ext.get(ticketId);
                    if (ticket != null) {
                        return TicketingMapper.buildTicket(ticket);
                    }
                    throw new PluginException("Failed to find ticket with id : " + ticketId);
                }
                catch (Exception e) {
                    throw new PluginException((Throwable)e);
                }
            }

            public void saveOrUpdate(Ticket ticket) throws PluginException {
                try {
                    org.opennms.integration.api.v1.ticketing.Ticket retrieved = TicketingMapper.buildTicket(ticket);
                    String ticketId = ext.saveOrUpdate(retrieved);
                    if (ticketId != null) {
                        ticket.setId(ticketId);
                    }
                }
                catch (Exception e) {
                    throw new PluginException((Throwable)e);
                }
            }
        };
    }
}

