/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.graph;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opennms.features.apilayer.common.utils.InterfaceMapper;
import org.opennms.features.apilayer.graph.GraphMapper;
import org.opennms.integration.api.v1.graph.GraphContainer;
import org.opennms.integration.api.v1.graph.GraphContainerInfo;
import org.opennms.integration.api.v1.graph.GraphContainerProvider;
import org.opennms.integration.api.v1.graph.configuration.GraphCacheStrategy;
import org.opennms.integration.api.v1.graph.configuration.GraphConfiguration;
import org.opennms.integration.api.v1.graph.configuration.TopologyConfiguration;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.osgi.framework.BundleContext;

public class GraphContainerProviderManager
extends InterfaceMapper<GraphContainerProvider, org.opennms.netmgt.graph.api.service.GraphContainerProvider> {
    public GraphContainerProviderManager(BundleContext bundleContext) {
        super(org.opennms.netmgt.graph.api.service.GraphContainerProvider.class, bundleContext);
    }

    public org.opennms.netmgt.graph.api.service.GraphContainerProvider map(final GraphContainerProvider extension) {
        return new org.opennms.netmgt.graph.api.service.GraphContainerProvider(){

            public ImmutableGraphContainer loadGraphContainer() {
                GraphContainer graphContainer = extension.loadGraphContainer();
                GenericGraphContainer convertedGraphContainer = new GraphMapper().map(graphContainer, extension.getGraphConfiguration());
                return convertedGraphContainer;
            }

            public org.opennms.netmgt.graph.api.info.GraphContainerInfo getContainerInfo() {
                GraphContainerInfo graphContainerInfo = extension.getGraphContainerInfo();
                org.opennms.netmgt.graph.api.info.GraphContainerInfo convertedGraphContainerInfo = new GraphMapper().map(graphContainerInfo);
                return convertedGraphContainerInfo;
            }
        };
    }

    public Map<String, Object> getServiceProperties(GraphContainerProvider extension) {
        return GraphContainerProviderManager.getServiceProperties(extension.getTopologyConfiguration(), extension.getGraphConfiguration());
    }

    public static ImmutableMap<String, Object> getServiceProperties(TopologyConfiguration topologyConfiguration, GraphConfiguration graphConfiguration) {
        GraphCacheStrategy.TimedGraphCacheStrategy timedGraphCacheStrategy;
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"expose-to-topology", (Object)Boolean.toString(topologyConfiguration.isLegacyTopology())).put((Object)"expose-status-provider", (Object)Boolean.toString(topologyConfiguration.getLegacyStatusStrategy() == TopologyConfiguration.LegacyStatusStrategy.Default)).put((Object)"resolve-node-ids", (Object)Boolean.toString(topologyConfiguration.shouldResolveNodes())).put((Object)"enrichment.resolveNodes", (Object)Boolean.toString(topologyConfiguration.shouldResolveNodes()));
        if (graphConfiguration.getGraphCacheStrategy() instanceof GraphCacheStrategy.TimedGraphCacheStrategy && (timedGraphCacheStrategy = (GraphCacheStrategy.TimedGraphCacheStrategy)graphConfiguration.getGraphCacheStrategy()).getCacheReloadIntervalInSeconds() > 0L) {
            builder.put((Object)"cacheInvalidateInterval", (Object)Long.toString(timedGraphCacheStrategy.getCacheReloadIntervalInSeconds()));
        }
        return builder.build();
    }
}

