/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.util;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.util.ExceptionUtils;

public final class ExtremeUtils {
    private static Log logger = LogFactory.getLog(ExtremeUtils.class);

    private ExtremeUtils() {
    }

    public static String camelCaseToWord(String camelCaseText) {
        if (StringUtils.isEmpty((CharSequence)camelCaseText)) {
            return camelCaseText;
        }
        if (camelCaseText.equals(camelCaseText.toUpperCase())) {
            return camelCaseText;
        }
        char[] ch = camelCaseText.toCharArray();
        String first = "" + ch[0];
        StringBuilder build = new StringBuilder(first.toUpperCase());
        for (int i = 1; i < ch.length; ++i) {
            String test = "" + ch[i];
            if (test.equals(test.toUpperCase())) {
                build.append(" ");
            }
            build.append(test);
        }
        return build.toString();
    }

    public static String formatDate(String parse, String format, Object value) {
        return ExtremeUtils.formatDate(parse, format, value, Locale.getDefault());
    }

    public static String formatDate(String parse, String format, Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            String valueAsString = value.toString();
            logger.error((Object)("The format was not defined for date [" + valueAsString + "]."));
            return valueAsString;
        }
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else {
            String valueAsString = value.toString();
            if (StringUtils.isBlank((CharSequence)valueAsString)) {
                return valueAsString;
            }
            if (StringUtils.isBlank((CharSequence)parse)) {
                logger.error((Object)("The parse was not defined for date String [" + valueAsString + "]."));
                return valueAsString;
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(parse, locale);
                date = simpleDateFormat.parse(valueAsString);
            }
            catch (Exception e) {
                logger.error((Object)("The parse was incorrectly defined for date String [" + valueAsString + "]."));
                return valueAsString;
            }
        }
        return DateFormatUtils.format((Date)date, (String)format, (Locale)locale);
    }

    public static String formatNumber(String format, Object value) {
        return ExtremeUtils.formatNumber(format, value, Locale.getDefault());
    }

    public static String formatNumber(String format, Object value, Locale locale) {
        String result = null;
        if (value == null) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            logger.error((Object)("The format was not defined for number [" + value.toString() + "]."));
            return value.toString();
        }
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyLocalizedPattern(format);
        return df.format(Double.parseDouble(value.toString()));
    }

    public static Object retrieveFromScope(PageContext pageContext, String name) {
        return ExtremeUtils.retrieveFromScope(pageContext, name, null);
    }

    public static Object retrieveFromScope(PageContext pageContext, String name, String scope) {
        if (StringUtils.isBlank((CharSequence)scope)) {
            return pageContext.findAttribute(name);
        }
        int scopeType = 2;
        if (scope.equalsIgnoreCase("page")) {
            scopeType = 1;
        } else if (scope.equalsIgnoreCase("application")) {
            scopeType = 4;
        } else if (scope.equalsIgnoreCase("session")) {
            scopeType = 3;
        }
        return pageContext.getAttribute(name, scopeType);
    }

    public static int sessionSize(HttpSession session) {
        int total = 0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Enumeration enumeration = session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object obj = session.getAttribute(name);
                oos.writeObject(obj);
                int size = baos.size();
                total += size;
                logger.debug((Object)("The session name: " + name + " and the size is: " + size));
            }
            logger.debug((Object)("Total session size is: " + total));
        }
        catch (Exception e) {
            logger.error((Object)("Could not get the session size - " + ExceptionUtils.formatStackTrace(e)));
        }
        return total;
    }

    public static boolean isBeanPropertyReadable(Object bean, String property) {
        boolean isReadable;
        if (bean instanceof Map) {
            return ((Map)bean).containsKey(property);
        }
        try {
            isReadable = PropertyUtils.isReadable((Object)bean, (String)property);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find the property [" + property + "]. Either the bean or property is null"));
            }
            isReadable = false;
        }
        return isReadable;
    }

    public static List<String> checkboxesSelected(HttpServletRequest request, String startsWithValue) {
        ArrayList<String> results = new ArrayList<String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.startsWith(startsWithValue)) continue;
            results.add(StringUtils.substringAfter((String)parameterName, (String)startsWithValue));
        }
        return results;
    }

    public static String getQueryString(Map<String, String[]> parameterMap) {
        StringBuilder results = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (results.length() == 0) {
                results.append("?");
            } else {
                results.append("&");
            }
            results.append(key + "=");
            if (value == null || value.length <= 0) continue;
            results.append(value[0]);
        }
        return results.toString();
    }
}

