/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import org.opennms.netmgt.provision.service.ProvisionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ImportOperation.class);
    private final ProvisionService m_provisionService;

    public ImportOperation(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    public abstract void scan();

    protected ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    protected abstract void doPersist();

    public abstract OperationType getOperationType();

    public void persist() {
        ImportOperation oper = this;
        LOG.info("Persist: {}", (Object)oper);
        this.doPersist();
        LOG.info("Clear cache: {}", (Object)this);
        this.getProvisionService().clearCache();
    }

    public static enum OperationType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

