/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.net.Inet6Address;
import java.util.concurrent.TimeUnit;
import org.opennms.core.tracker.ResponseWithId;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequestId;
import org.opennms.protocols.icmp6.ICMPv6EchoReply;

public final class Jni6PingResponse
implements ResponseWithId<Jni6PingRequestId>,
EchoPacket {
    private final Inet6Address m_address;
    private final ICMPv6EchoReply m_packet;

    public Jni6PingResponse(Inet6Address addr, ICMPv6EchoReply echoReply) {
        this.m_packet = echoReply;
        this.m_address = addr;
    }

    private ICMPv6EchoReply getPacket() {
        return this.m_packet;
    }

    public Inet6Address getAddress() {
        return this.m_address;
    }

    public Jni6PingRequestId getRequestId() {
        return new Jni6PingRequestId(this);
    }

    public boolean isEchoReply() {
        return this.getPacket().isEchoReply();
    }

    public int getIdentifier() {
        return this.getPacket().getIdentifier();
    }

    public int getSequenceNumber() {
        return this.getPacket().getSequenceNumber();
    }

    public long getThreadId() {
        return this.getPacket().getThreadId();
    }

    public long getSentTimeNanos() {
        return this.getPacket().getSentTime() * 1000000L;
    }

    public long getReceivedTimeNanos() {
        return this.getPacket().getReceiveTime() * 1000000L;
    }

    public double elapsedTime(TimeUnit timeUnit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return (double)(this.getPacket().getRoundTripTime() * 1000L) / nanosPerUnit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('[');
        buf.append("Address = ").append(this.getAddress());
        buf.append(", ");
        buf.append("JniPingRequestId = ").append(this.getRequestId().toString());
        buf.append(']');
        return buf.toString();
    }
}

