/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.ISnmp;

public final class ImmutableSnmp
implements ISnmp {
    private final String id;
    private final String trapOID;
    private final String idText;
    private final String version;
    private final Integer specific;
    private final Integer generic;
    private final String community;
    private final Long timeStamp;

    private ImmutableSnmp(Builder builder) {
        this.id = builder.id;
        this.idText = builder.idText;
        this.version = builder.version;
        this.specific = builder.specific;
        this.generic = builder.generic;
        this.community = builder.community;
        this.timeStamp = builder.timeStamp;
        this.trapOID = builder.trapOID;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(ISnmp snmp) {
        return new Builder(snmp);
    }

    public static ISnmp immutableCopy(ISnmp snmp) {
        if (snmp == null || snmp instanceof ImmutableSnmp) {
            return snmp;
        }
        return ImmutableSnmp.newBuilderFrom(snmp).build();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTrapOID() {
        return this.trapOID;
    }

    @Override
    public String getIdtext() {
        return this.idText;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Integer getSpecific() {
        return this.specific == null ? 0 : this.specific;
    }

    @Override
    public Integer getGeneric() {
        return this.generic == null ? 0 : this.generic;
    }

    @Override
    public String getCommunity() {
        return this.community;
    }

    @Override
    public Long getTimeStamp() {
        return this.timeStamp == null ? 0L : this.timeStamp;
    }

    @Override
    public boolean hasGeneric() {
        return this.generic != null;
    }

    @Override
    public boolean hasSpecific() {
        return this.specific != null;
    }

    @Override
    public boolean hasTimeStamp() {
        return this.timeStamp != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSnmp that = (ImmutableSnmp)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.idText, that.idText) && Objects.equals(this.version, that.version) && Objects.equals(this.specific, that.specific) && Objects.equals(this.generic, that.generic) && Objects.equals(this.community, that.community) && Objects.equals(this.timeStamp, that.timeStamp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idText, this.version, this.specific, this.generic, this.community, this.timeStamp);
    }

    public String toString() {
        return "ImmutableSnmp{id='" + this.id + "', idText='" + this.idText + "', version='" + this.version + "', specific=" + this.specific + ", generic=" + this.generic + ", community='" + this.community + "', timeStamp=" + this.timeStamp + "}";
    }

    public static final class Builder {
        private String id;
        private String idText;
        private String version;
        private Integer specific;
        private Integer generic;
        private String community;
        private Long timeStamp;
        private String trapOID;

        private Builder() {
        }

        public Builder(ISnmp snmp) {
            this.id = snmp.getId();
            this.idText = snmp.getIdtext();
            this.version = snmp.getVersion();
            this.specific = snmp.getSpecific();
            this.generic = snmp.getGeneric();
            this.community = snmp.getCommunity();
            this.timeStamp = snmp.getTimeStamp();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTrapOID(String trapOID) {
            this.trapOID = trapOID;
            return this;
        }

        public Builder setIdText(String idText) {
            this.idText = idText;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setSpecific(Integer specific) {
            this.specific = specific;
            return this;
        }

        public Builder setGeneric(Integer generic) {
            this.generic = generic;
            return this;
        }

        public Builder setCommunity(String community) {
            this.community = community;
            return this;
        }

        public Builder setTimeStamp(Long timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public ImmutableSnmp build() {
            return new ImmutableSnmp(this);
        }
    }
}

