/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.asteriskjava.config.Category;
import org.asteriskjava.config.ConfigDirective;
import org.asteriskjava.config.ConfigElement;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.config.ConfigFileImpl;
import org.asteriskjava.config.ConfigParseException;
import org.asteriskjava.config.ConfigVariable;
import org.asteriskjava.config.ExecDirective;
import org.asteriskjava.config.IncludeDirective;
import org.asteriskjava.config.MissingDirectiveParameterException;
import org.asteriskjava.config.MissingEqualSignException;
import org.asteriskjava.config.UnknownDirectiveException;

public class ConfigFileReader {
    private static final int MAX_LINE_LENGTH = 8192;
    private static char COMMENT_META = (char)59;
    private static char COMMENT_TAG = (char)45;
    private static final Set<Class<?>> WARNING_CLASSES = new HashSet();
    private StringBuilder commentBlock = new StringBuilder();
    protected final Map<String, Category> categories = new LinkedHashMap<String, Category>();
    private final List<ConfigParseException> warnings = new ArrayList<ConfigParseException>();
    protected Category currentCategory;
    private int currentCommentLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile readFile(String configfile) throws IOException, ConfigParseException {
        BufferedReader reader = new BufferedReader(new FileReader(configfile));
        try {
            this.readFile(configfile, reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        ConfigFileImpl result = new ConfigFileImpl(configfile, new TreeMap<String, Category>(this.categories));
        return result;
    }

    void reset() {
        this.commentBlock = new StringBuilder();
        this.categories.clear();
        this.warnings.clear();
        this.currentCategory = null;
        this.currentCommentLevel = 0;
    }

    Collection<Category> getCategories() {
        return this.categories.values();
    }

    public Collection<ConfigParseException> getWarnings() {
        return new ArrayList<ConfigParseException>(this.warnings);
    }

    void readFile(String configfile, BufferedReader reader) throws IOException, ConfigParseException {
        String line;
        int lineno = 0;
        CharBuffer buffer = CharBuffer.allocate(8192);
        this.reset();
        while ((line = reader.readLine()) != null) {
            ++lineno;
            buffer.clear();
            buffer.put(line);
            buffer.put("\n");
            buffer.flip();
            this.processLine(configfile, lineno, buffer);
        }
    }

    ConfigElement processLine(String configfile, int lineno, CharBuffer buffer) throws ConfigParseException {
        ConfigElement configElement;
        StringBuilder processLineBuilder = new StringBuilder(8192);
        StringBuilder lineCommentBuilder = new StringBuilder(8192);
        buffer.mark();
        while (buffer.hasRemaining()) {
            int position = buffer.position();
            char c = buffer.get();
            if (c == COMMENT_META && (position < 1 || buffer.get(position - 1) != '\\')) {
                if (buffer.remaining() >= 3 && buffer.get(position + 1) == COMMENT_TAG && buffer.get(position + 2) == COMMENT_TAG && buffer.get(position + 3) != COMMENT_TAG) {
                    ++this.currentCommentLevel;
                    if (!this.inComment()) {
                        this.commentBlock.append(";--");
                        buffer.position(position + 3);
                        buffer.mark();
                        continue;
                    }
                } else if (this.inComment() && position >= 2 && buffer.get(position - 1) == COMMENT_TAG && buffer.get(position - 2) == COMMENT_TAG) {
                    --this.currentCommentLevel;
                    if (!this.inComment()) {
                        buffer.reset();
                        this.commentBlock.append(c);
                        buffer.position(position + 1);
                        buffer.compact();
                        buffer.flip();
                        continue;
                    }
                } else if (!this.inComment()) {
                    while (buffer.hasRemaining()) {
                        lineCommentBuilder.append(buffer.get());
                    }
                    break;
                }
            }
            if (this.inComment()) {
                this.commentBlock.append(c);
                continue;
            }
            processLineBuilder.append(c);
        }
        String processLineString = processLineBuilder.toString().trim();
        String lineCommentString = lineCommentBuilder.toString().trim();
        if (processLineString.length() == 0) {
            if (lineCommentString.length() != 0) {
                this.commentBlock.append(";");
                this.commentBlock.append(lineCommentString);
            }
            if (!this.inComment()) {
                this.commentBlock.append("\n");
            }
            return null;
        }
        try {
            configElement = this.processTextLine(configfile, lineno, processLineString);
        }
        catch (ConfigParseException e) {
            if (WARNING_CLASSES.contains(e.getClass())) {
                this.warnings.add(e);
                return null;
            }
            throw e;
        }
        if (lineCommentString.length() != 0) {
            configElement.setComment(lineCommentString);
        }
        if (this.commentBlock.length() != 0) {
            configElement.setPreComment(this.commentBlock.toString());
            this.commentBlock.delete(0, this.commentBlock.length());
        }
        return configElement;
    }

    boolean inComment() {
        return this.currentCommentLevel != 0;
    }

    protected ConfigElement processTextLine(String configfile, int lineno, String line) throws ConfigParseException {
        ConfigElement configElement;
        if (line.charAt(0) == '[') {
            configElement = this.parseCategoryHeader(configfile, lineno, line);
        } else if (line.charAt(0) == '#') {
            configElement = this.parseDirective(configfile, lineno, line);
        } else {
            if (this.currentCategory == null) {
                throw new ConfigParseException(configfile, lineno, "parse error: No category context for line %d of %s", lineno, configfile);
            }
            configElement = this.parseVariable(configfile, lineno, line);
            this.currentCategory.addElement(configElement);
        }
        return configElement;
    }

    protected Category parseCategoryHeader(String configfile, int lineno, String line) throws ConfigParseException {
        int nameEndPos = line.indexOf(93);
        if (nameEndPos == -1) {
            throw new ConfigParseException(configfile, lineno, "parse error: no closing ']', line %d of %s", lineno, configfile);
        }
        String name = line.substring(1, nameEndPos);
        Category category = new Category(configfile, lineno, name);
        if (line.length() > nameEndPos + 1 && line.charAt(nameEndPos + 1) == '(') {
            String[] options;
            String optionsString = line.substring(nameEndPos + 1);
            int optionsEndPos = optionsString.indexOf(41);
            if (optionsEndPos == -1) {
                throw new ConfigParseException(configfile, lineno, "parse error: no closing ')', line %d of %s", lineno, configfile);
            }
            for (String cur : options = optionsString.substring(1, optionsEndPos).split(",")) {
                if ("!".equals(cur)) {
                    category.markAsTemplate();
                    continue;
                }
                if ("+".equals(cur)) {
                    Category categoryToAddTo = this.categories.get(name);
                    if (categoryToAddTo != null) continue;
                    throw new ConfigParseException(configfile, lineno, "Category addition requested, but category '%s' does not exist, line %d of %s", name, lineno, configfile);
                }
                Category baseCategory = this.categories.get(cur);
                if (baseCategory == null) {
                    throw new ConfigParseException(configfile, lineno, "Inheritance requested, but category '%s' does not exist, line %d of %s", cur, lineno, configfile);
                }
                this.inheritCategory(category, baseCategory);
            }
        }
        this.appendCategory(category);
        return category;
    }

    ConfigDirective parseDirective(String configfile, int lineno, String line) throws ConfigParseException {
        ConfigDirective directive;
        String name = null;
        StringBuilder nameBuilder = new StringBuilder();
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (name == null) {
                nameBuilder.append(c);
                if (!Character.isWhitespace(c) && i + 1 != line.length()) continue;
                name = nameBuilder.toString().trim();
                continue;
            }
            paramBuilder.append(c);
        }
        String param = paramBuilder.toString().trim();
        if (param.length() != 0 && (param.charAt(0) == '\"' || param.charAt(0) == '<' || param.charAt(0) == '>')) {
            param = param.substring(1);
        }
        int endPos = param.length() - 1;
        if (param.length() != 0 && (param.charAt(endPos) == '\"' || param.charAt(endPos) == '<' || param.charAt(endPos) == '>')) {
            param = param.substring(0, endPos);
        }
        if ("exec".equalsIgnoreCase(name)) {
            directive = new ExecDirective(configfile, lineno, param);
        } else if ("include".equalsIgnoreCase(name)) {
            directive = new IncludeDirective(configfile, lineno, param);
        } else {
            throw new UnknownDirectiveException(configfile, lineno, "Unknown directive '%s' at line %d of %s", name, lineno, configfile);
        }
        if (param.length() == 0) {
            throw new MissingDirectiveParameterException(configfile, lineno, "Directive '#%s' needs an argument (%s) at line %d of %s", name.toLowerCase(Locale.US), "include".equalsIgnoreCase(name) ? "filename" : "/path/to/executable", lineno, configfile);
        }
        return directive;
    }

    protected ConfigVariable parseVariable(String configfile, int lineno, String line) throws ConfigParseException {
        int pos = line.indexOf(61);
        if (pos == -1) {
            throw new MissingEqualSignException(configfile, lineno, "No '=' (equal sign) in line %d of %s", lineno, configfile);
        }
        String name = line.substring(0, pos).trim();
        if (line.length() > pos + 1 && line.charAt(pos + 1) == '>') {
            ++pos;
        }
        String value = line.length() > pos + 1 ? line.substring(pos + 1).trim() : "";
        return new ConfigVariable(configfile, lineno, name, value);
    }

    void inheritCategory(Category category, Category baseCategory) {
        category.addBaseCategory(baseCategory);
    }

    void appendCategory(Category category) {
        this.categories.put(category.getName(), category);
        this.currentCategory = category;
    }

    static {
        WARNING_CLASSES.add(MissingEqualSignException.class);
        WARNING_CLASSES.add(UnknownDirectiveException.class);
        WARNING_CLASSES.add(MissingDirectiveParameterException.class);
    }
}

