/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import gnu.crypto.prng.IRandom;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import rpc.IntegrityException;
import rpc.Security;
import rpc.security.ntlm.DigestHelper;
import rpc.security.ntlm.NTLMKeyFactory;

public class Ntlm1
implements NtlmFlags,
Security {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final byte[] CLIENT_SIGNING_MAGIC_CONSTANT = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 45, 116, 111, 45, 115, 101, 114, 118, 101, 114, 32, 115, 105, 103, 110, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] SERVER_SIGNING_MAGIC_CONSTANT = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 115, 101, 114, 118, 101, 114, 45, 116, 111, 45, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] CLIENT_SEALING_MAGIC_CONSTANT = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 45, 116, 111, 45, 115, 101, 114, 118, 101, 114, 32, 115, 101, 97, 108, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] SERVER_SEALING_MAGIC_CONSTANT = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 115, 101, 114, 118, 101, 114, 45, 116, 111, 45, 99, 108, 105, 101, 110, 116, 32, 115, 101, 97, 108, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final int NTLM1_VERIFIER_LENGTH = 16;
    private final IRandom clientCipher;
    private final IRandom serverCipher;
    private final byte[] clientSigningKey;
    private final byte[] serverSigningKey;
    private final boolean isServer;
    private final int protectionLevel;
    private int requestCounter = 0;
    private int responseCounter = 0;
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public Ntlm1(int flags, byte[] sessionKey, boolean isServer) {
        this.protectionLevel = (flags & 0x20) != 0 ? 6 : 5;
        this.isServer = isServer;
        this.clientSigningKey = Ntlm1.generateClientSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.serverSigningKey = Ntlm1.generateServerSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] clientSealingKey = Ntlm1.generateClientSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.clientCipher = NTLMKeyFactory.getARCFOUR(clientSealingKey);
        byte[] serverSealingKey = Ntlm1.generateServerSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.serverCipher = NTLMKeyFactory.getARCFOUR(serverSealingKey);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Client Signing Key derieved from the session key: [{0}]", Ntlm1.dumpString(this.clientSigningKey));
            LOGGER.log(Level.FINEST, "Client Sealing Key derieved from the session key: [{0}]", Ntlm1.dumpString(clientSealingKey));
            LOGGER.log(Level.FINEST, "Server Signing Key derieved from the session key: [{0}]", Ntlm1.dumpString(this.serverSigningKey));
            LOGGER.log(Level.FINEST, "Server Sealing Key derieved from the session key: [{0}]", Ntlm1.dumpString(serverSealingKey));
        }
    }

    @Override
    public int getVerifierLength() {
        return 16;
    }

    @Override
    public int getAuthenticationService() {
        return 10;
    }

    @Override
    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public void processIncoming(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            IRandom cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (!this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (this.getProtectionLevel() == 6) {
                data = NTLMKeyFactory.applyARCFOUR(cipher, data);
                System.arraycopy(data, 0, ndr.getBuffer().buf, index, data.length);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.info("AFTER Decryption");
                LOGGER.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                LOGGER.log(Level.FINEST, "\nLength is: {0}", data.length);
            }
            byte[] verifier = NTLMKeyFactory.signingPt1(this.responseCounter, signingKey, buffer.getBuffer(), verifierIndex);
            NTLMKeyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            byte[] signing = new byte[16];
            ndr.readOctetArray(signing, 0, signing.length);
            if (!NTLMKeyFactory.compareSignature(verifier, signing)) {
                throw new IntegrityException("Message out of sequence. Perhaps the user being used to run this application is different from the one under which the COM server is running !.");
            }
            ++this.responseCounter;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "", ex);
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    @Override
    public void processOutgoing(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            IRandom cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] verifier = NTLMKeyFactory.signingPt1(this.requestCounter, signingKey, buffer.getBuffer(), verifierIndex);
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.info("BEFORE Encryption");
                LOGGER.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                LOGGER.log(Level.INFO, "Length is: {0}", data.length);
            }
            if (this.getProtectionLevel() == 6) {
                byte[] data2 = NTLMKeyFactory.applyARCFOUR(cipher, data);
                System.arraycopy(data2, 0, ndr.getBuffer().buf, index, data2.length);
            }
            NTLMKeyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            buffer.writeOctetArray(verifier, 0, verifier.length);
            ++this.requestCounter;
        }
        catch (RuntimeException | NoSuchAlgorithmException ex) {
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    public static String dumpString(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    private static byte[] generateClientSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + CLIENT_SIGNING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(CLIENT_SIGNING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, CLIENT_SIGNING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateClientSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + CLIENT_SEALING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(CLIENT_SEALING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, CLIENT_SEALING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateServerSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + SERVER_SIGNING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(SERVER_SIGNING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, SERVER_SIGNING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateServerSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + SERVER_SEALING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(SERVER_SEALING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, SERVER_SEALING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }
}

