/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.persistence.impl;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.StringUtils;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfig;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigQueryResult;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigStatus;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class DeviceConfigDaoImpl
extends AbstractDaoHibernate<DeviceConfig, Long>
implements DeviceConfigDao {
    private static final Map<String, String> ORDERBY_QUERY_PROPERTY_MAP = Map.of("lastupdated", "last_updated", "devicename", "nodelabel", "lastbackup", "created_time", "ipaddress", "ipaddr", "location", "location", "status", "status");
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigDaoImpl.class);
    private static final int DEFAULT_LIMIT = 20;

    public DeviceConfigDaoImpl() {
        super(DeviceConfig.class);
    }

    @Override
    public List<DeviceConfig> findConfigsForInterfaceSortedByDate(OnmsIpInterface ipInterface, String serviceName) {
        return this.find("from DeviceConfig dc where dc.lastUpdated is not null AND dc.ipInterface.id = ? AND serviceName = ? ORDER BY lastUpdated DESC", ipInterface.getId(), serviceName);
    }

    @Override
    public List<DeviceConfig> findStaleConfigs(OnmsIpInterface ipInterface, String serviceName, Date staleDate, Optional<Long> excludedId) {
        CriteriaBuilder builder = new CriteriaBuilder(DeviceConfig.class);
        builder.isNotNull("lastUpdated").isNotNull("config").eq("ipInterface.id", (Object)ipInterface.getId()).eq("serviceName", (Object)serviceName).lt("lastUpdated", (Object)staleDate);
        if (excludedId.isPresent()) {
            builder.not().eq("id", (Object)excludedId.get());
        }
        Criteria criteria = builder.toCriteria();
        return this.findMatching(criteria);
    }

    @Override
    public Optional<DeviceConfig> getLatestConfigForInterface(OnmsIpInterface ipInterface, String serviceName) {
        List<Object> deviceConfigs = new ArrayList();
        deviceConfigs = !Strings.isNullOrEmpty((String)serviceName) ? this.findObjects(DeviceConfig.class, "from DeviceConfig dc WHERE dc.ipInterface.id = ? AND serviceName = ? ORDER BY lastUpdated DESC LIMIT 1", ipInterface.getId(), serviceName) : this.findObjects(DeviceConfig.class, "from DeviceConfig dc WHERE dc.ipInterface.id = ? AND serviceName is NULL ORDER BY lastUpdated DESC LIMIT 1", ipInterface.getId());
        if (!deviceConfigs.isEmpty()) {
            return Optional.of((DeviceConfig)deviceConfigs.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<DeviceConfigQueryResult> getLatestConfigForEachInterface(Integer limit, Integer offset, String orderBy, String sortOrder, String searchTerm, Set<DeviceConfigStatus> statuses) {
        DeviceConfigQueryCriteria criteria = this.createSqlQueryCriteria(limit, offset, orderBy, sortOrder, searchTerm, statuses);
        String queryString = "SELECT * FROM (\n    SELECT\n        DISTINCT ON(dc.ipinterface_id, dc.config_type)\n        {dc.*},\n        {ip.*},\n        dc.last_updated,\n        dc.created_time,\n        dc.status,\n        ip.ipaddr,\n        n.nodeid,\n        n.nodelabel,\n        n.operatingsystem,\n        n.location\n    FROM device_config dc\n    JOIN ipinterface ip\n        ON dc.ipinterface_id = ip.id\n    JOIN node n\n        ON ip.nodeid = n.nodeid\n    ORDER BY dc.ipinterface_id, dc.config_type, dc.last_updated DESC\n) q\n" + (String)(criteria.hasFilter ? criteria.filter + "\n" : "") + (String)(criteria.hasOrderBy ? criteria.orderBy + "\n" : "") + criteria.limitOffset;
        LOG.debug("DeviceConfigDaoImpl.getLatestConfigs, query string:");
        LOG.debug(queryString);
        List resultList = (List)this.getHibernateTemplate().executeWithNativeSession(session -> {
            SQLQuery queryObject = session.createSQLQuery(queryString).addEntity("dc", DeviceConfig.class).addJoin("ip", "dc.ipInterface");
            if (criteria.hasFilter && !Strings.isNullOrEmpty((String)criteria.searchTerm)) {
                queryObject.setParameter("searchTerm", (Object)criteria.searchTerm);
            }
            List queryList = queryObject.setResultTransformer(new ResultTransformer(){

                public Object transformTuple(Object[] objects, String[] strings) {
                    if (objects != null && objects.length >= 2) {
                        DeviceConfig dc = (DeviceConfig)objects[0];
                        OnmsIpInterface ip = (OnmsIpInterface)objects[1];
                        OnmsNode n = ip.getNode();
                        return new DeviceConfigQueryResult(dc, ip, n);
                    }
                    return null;
                }

                public List transformList(List list) {
                    return list;
                }
            }).list();
            return queryList;
        });
        return resultList;
    }

    @Override
    public int getLatestConfigCountForEachInterface(String searchTerm, Set<DeviceConfigStatus> statuses) {
        boolean hasSearchTerm = !Strings.isNullOrEmpty((String)searchTerm);
        Object hql = "SELECT COUNT (DISTINCT dc.ipInterface.id)\nFROM DeviceConfig dc\nINNER JOIN dc.ipInterface AS ip";
        if (hasSearchTerm) {
            hql = (String)hql + "\nINNER JOIN ip.node AS node\nWHERE (node.label LIKE ? OR ip.ipAddress LIKE ?)";
        }
        if (statuses != null && !statuses.isEmpty()) {
            String statusQuery = this.getStatusSubquery(statuses);
            hql = (String)hql + "\n" + (hasSearchTerm ? "AND " : "WHERE ") + statusQuery;
        }
        int count = hasSearchTerm ? this.queryInt((String)hql, "%" + searchTerm + "%", "%" + searchTerm + "%") : this.queryInt((String)hql);
        return count;
    }

    @Override
    public List<DeviceConfig> getAllDeviceConfigsWithAnInterfaceId(Integer ipInterfaceId) {
        return this.find("from DeviceConfig dc where dc.ipInterface.id = ? ", ipInterfaceId);
    }

    @Override
    public Map<String, Long> getNumberOfNodesWithDeviceConfigBySysOid() {
        String query = "SELECT n.nodesysoid, count(*) FROM device_config dcb LEFT JOIN ipinterface ip ON ipinterface_id = ip.id LEFT JOIN node n ON ip.nodeid = n.nodeid GROUP BY nodesysoid";
        return (Map)this.getHibernateTemplate().executeWithNativeSession(session -> {
            SQLQuery queryObject = session.createSQLQuery(query);
            HashMap<String, Long> numberOfNodesWithDeviceConfigBySysOid = new HashMap<String, Long>();
            for (Object obj : queryObject.list()) {
                Object[] pair = (Object[])obj;
                String sysOid = (String)pair[0];
                Long count = ((BigInteger)pair[1]).longValue();
                numberOfNodesWithDeviceConfigBySysOid.put(StringUtils.isEmpty((String)sysOid) ? "none" : sysOid, count);
            }
            return Collections.unmodifiableMap(numberOfNodesWithDeviceConfigBySysOid);
        });
    }

    private DeviceConfigQueryCriteria createSqlQueryCriteria(Integer limit, Integer offset, String orderBy, String order, String searchTerm, Set<DeviceConfigStatus> statuses) {
        DeviceConfigQueryCriteria criteria = new DeviceConfigQueryCriteria();
        if (!Strings.isNullOrEmpty((String)searchTerm)) {
            criteria.hasFilter = true;
            criteria.searchTerm = "%" + searchTerm + "%";
            criteria.filter = "WHERE (nodelabel LIKE :searchTerm OR ipaddr LIKE :searchTerm)";
        }
        if (statuses != null && !statuses.isEmpty()) {
            criteria.hasFilter = true;
            String statusQuery = this.getStatusSubquery(statuses);
            criteria.filter = Strings.isNullOrEmpty((String)criteria.filter) ? "WHERE " + statusQuery : criteria.filter + "\nAND " + statusQuery;
        }
        if (!Strings.isNullOrEmpty((String)orderBy) && ORDERBY_QUERY_PROPERTY_MAP.containsKey(orderBy.toLowerCase(Locale.ROOT))) {
            String orderByValue = ORDERBY_QUERY_PROPERTY_MAP.get(orderBy.toLowerCase(Locale.ROOT));
            boolean isOrderDescending = !Strings.isNullOrEmpty((String)order) && "desc".equals(order);
            String orderByClause = String.format("ORDER BY %s%s", orderByValue, isOrderDescending ? " DESC" : "");
            criteria.hasOrderBy = true;
            criteria.orderBy = orderByClause;
        }
        int limitToUse = limit != null && limit > 0 ? limit : 20;
        int offsetToUse = offset != null && offset > 0 ? offset : 0;
        criteria.limitOffset = String.format("LIMIT %d OFFSET %d", limitToUse, offsetToUse);
        return criteria;
    }

    private String getStatusSubquery(Set<DeviceConfigStatus> statuses) {
        String statusNames = statuses.stream().map(s -> "'" + s.name() + "'").collect(Collectors.joining(","));
        return "status IN (" + statusNames + ")";
    }

    @Override
    public Optional<Long> updateDeviceConfigContent(OnmsIpInterface ipInterface, String serviceName, String configType, String encoding, byte[] deviceConfigBytes, String fileName) {
        Date currentTime = new Date();
        Optional<DeviceConfig> configOptional = this.getLatestConfigForInterface(ipInterface, serviceName);
        DeviceConfig lastDeviceConfig = configOptional.orElse(null);
        Optional<Long> updatedDeviceId = configOptional.map(DeviceConfig::getId);
        if (lastDeviceConfig != null && Arrays.equals(lastDeviceConfig.getConfig(), deviceConfigBytes)) {
            lastDeviceConfig.setLastUpdated(currentTime);
            lastDeviceConfig.setLastSucceeded(currentTime);
            lastDeviceConfig.setFileName(fileName);
            lastDeviceConfig.setStatus(DeviceConfigStatus.SUCCESS);
            this.saveOrUpdate(lastDeviceConfig);
            LOG.debug("Device config did not change - ipInterface: {}; service: {}; type: {}", new Object[]{ipInterface, serviceName, configType});
        } else if (lastDeviceConfig != null && lastDeviceConfig.getConfig() == null) {
            lastDeviceConfig.setConfig(deviceConfigBytes);
            lastDeviceConfig.setFileName(fileName);
            lastDeviceConfig.setCreatedTime(currentTime);
            lastDeviceConfig.setLastUpdated(currentTime);
            lastDeviceConfig.setLastSucceeded(currentTime);
            lastDeviceConfig.setFailureReason(null);
            lastDeviceConfig.setStatus(DeviceConfigStatus.SUCCESS);
            this.saveOrUpdate(lastDeviceConfig);
            LOG.info("Persisted device config - ipInterface: {}; service: {}; type: {}", new Object[]{ipInterface, serviceName, configType});
        } else {
            DeviceConfig deviceConfig = new DeviceConfig();
            deviceConfig.setConfig(deviceConfigBytes);
            deviceConfig.setFileName(fileName);
            deviceConfig.setCreatedTime(currentTime);
            deviceConfig.setIpInterface(ipInterface);
            deviceConfig.setServiceName(serviceName);
            deviceConfig.setEncoding(encoding);
            deviceConfig.setConfigType(configType);
            deviceConfig.setLastUpdated(currentTime);
            deviceConfig.setLastSucceeded(currentTime);
            deviceConfig.setStatus(DeviceConfigStatus.SUCCESS);
            this.saveOrUpdate(deviceConfig);
            updatedDeviceId = Optional.of(deviceConfig.getId());
            LOG.info("Persisted changed device config - ipInterface: {}; service: {}; type: {}", new Object[]{ipInterface, serviceName, configType});
        }
        return updatedDeviceId;
    }

    @Override
    public void updateDeviceConfigFailure(OnmsIpInterface ipInterface, String serviceName, String configType, String encoding, String reason) {
        DeviceConfig deviceConfig;
        Date currentTime = new Date();
        Optional<DeviceConfig> configOptional = this.getLatestConfigForInterface(ipInterface, serviceName);
        DeviceConfig lastDeviceConfig = configOptional.orElse(null);
        if (lastDeviceConfig != null) {
            deviceConfig = lastDeviceConfig;
        } else {
            deviceConfig = new DeviceConfig();
            deviceConfig.setIpInterface(ipInterface);
            deviceConfig.setServiceName(serviceName);
            deviceConfig.setConfigType(configType);
            deviceConfig.setEncoding(encoding);
        }
        deviceConfig.setFailureReason(reason);
        deviceConfig.setLastFailed(currentTime);
        deviceConfig.setLastUpdated(currentTime);
        deviceConfig.setStatus(DeviceConfigStatus.FAILED);
        this.saveOrUpdate(deviceConfig);
        LOG.warn("Persisted device config backup failure - ipInterface: {}; service: {}; type: {}; reason: {}", new Object[]{ipInterface, serviceName, configType, reason});
    }

    @Override
    public void createEmptyDeviceConfig(OnmsIpInterface ipInterface, String serviceName, String configType) {
        DeviceConfig deviceConfig = new DeviceConfig();
        deviceConfig.setIpInterface(ipInterface);
        deviceConfig.setServiceName(serviceName);
        deviceConfig.setConfigType(configType);
        deviceConfig.setStatus(DeviceConfigStatus.NONE);
        this.saveOrUpdate(deviceConfig);
    }

    @Override
    public void deleteDeviceConfigs(Collection<DeviceConfig> entities) throws DataAccessException {
        super.deleteAll(entities);
    }

    private static class DeviceConfigQueryCriteria {
        public String filter;
        public boolean hasFilter;
        public String searchTerm;
        public String orderBy;
        public boolean hasOrderBy;
        public String limitOffset;

        private DeviceConfigQueryCriteria() {
        }
    }
}

