/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLStatus;
import org.opennms.netmgt.model.OnmsSeverity;

public class GraphMLVertexStatus
extends GraphMLStatus {
    private long alarmCount;

    public GraphMLVertexStatus(OnmsSeverity severity, long alarmCount, Map<String, String> styleProperties) {
        super(severity, styleProperties);
        this.alarmCount = alarmCount;
    }

    public GraphMLVertexStatus(OnmsSeverity severity, long alarmCount) {
        super(severity);
        this.alarmCount = alarmCount;
    }

    public GraphMLVertexStatus() {
        super(OnmsSeverity.NORMAL);
    }

    @Override
    public Set<String> getAllowedStyleProperties() {
        return Collections.emptySet();
    }

    public long getAlarmCount() {
        return this.alarmCount;
    }

    public final GraphMLStatus alarmCount(long alarmCount) {
        this.alarmCount = alarmCount;
        return this;
    }

    @Override
    public Map<String, String> getStatusProperties() {
        return ImmutableMap.builder().putAll(super.getStatusProperties()).put((Object)"statusCount", (Object)Long.toString(this.alarmCount)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphMLVertexStatus)) {
            return false;
        }
        GraphMLVertexStatus that = (GraphMLVertexStatus)o;
        return Objects.equal((Object)this.getSeverity(), (Object)that.getSeverity()) && Objects.equal((Object)this.getAlarmCount(), (Object)that.getAlarmCount()) && Objects.equal(this.getStyleProperties(), that.getStyleProperties());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSeverity(), this.getAlarmCount(), this.getStyleProperties()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("severity", (Object)this.getSeverity()).add("alarmCount", this.getAlarmCount()).add("styleProperties", this.getStyleProperties()).toString();
    }

    public static GraphMLVertexStatus merge(GraphMLVertexStatus s1, GraphMLVertexStatus s2) {
        return new GraphMLVertexStatus(GraphMLStatus.mergeSeverity(s1, s2), s1.alarmCount + s2.alarmCount, GraphMLStatus.mergeStyleProperties(s1, s2));
    }
}

