/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.LocalBgpNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.LocalNoNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.Reason;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.RemoteBgpNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.RemoteNoNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.Unknown;

public class PeerDownPacket
implements Packet {
    public final Header header;
    public final PeerHeader peerHeader;
    public final Type type;
    public final Reason reason;

    public PeerDownPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.peerHeader = new PeerHeader(buffer);
        this.type = Type.from(BufferUtils.uint8((ByteBuf)buffer));
        this.reason = this.type.parse(buffer, this.peerHeader.flags, peerAccessor.getPeerInfo(this.peerHeader));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("peerHeader", (Object)this.peerHeader).add("type", (Object)this.type).add("reason", (Object)this.reason).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        LOCAL_BGP_NOTIFICATION{

            @Override
            public Reason parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new LocalBgpNotification(buffer, flags, peerInfo);
            }
        }
        ,
        LOCAL_NO_NOTIFICATION{

            @Override
            public Reason parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new LocalNoNotification(buffer, flags, peerInfo);
            }
        }
        ,
        REMOTE_BGP_NOTIFICATION{

            @Override
            public Reason parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new RemoteBgpNotification(buffer, flags, peerInfo);
            }
        }
        ,
        REMOTE_NO_NOTIFICATION{

            @Override
            public Reason parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new RemoteNoNotification(buffer, flags, peerInfo);
            }
        }
        ,
        UNKNOWN{

            @Override
            public Reason parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                return new Unknown(buffer, flags, peerInfo);
            }
        };


        public abstract Reason parse(ByteBuf var1, PeerFlags var2, Optional<PeerInfo> var3) throws InvalidPacketException;

        private static Type from(int type) {
            switch (type) {
                case 1: {
                    return LOCAL_BGP_NOTIFICATION;
                }
                case 2: {
                    return LOCAL_NO_NOTIFICATION;
                }
                case 3: {
                    return REMOTE_BGP_NOTIFICATION;
                }
                case 4: {
                    return REMOTE_NO_NOTIFICATION;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Peer Down Type: {}", (Object)type);
            return UNKNOWN;
        }
    }
}

