/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.websso;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.IDPEntry;
import org.opensaml.saml2.core.IDPList;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.RequesterID;
import org.opensaml.saml2.core.Scoping;
import org.opensaml.saml2.core.impl.RequesterIDBuilder;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.storage.SAMLMessageStorage;
import org.springframework.security.saml.websso.AbstractProfileBase;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.util.CollectionUtils;

public class WebSSOProfileImpl
extends AbstractProfileBase
implements WebSSOProfile {
    public WebSSOProfileImpl() {
    }

    public WebSSOProfileImpl(SAMLProcessor processor, MetadataManager manager) {
        super(processor, manager);
    }

    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    }

    @Override
    public void sendAuthenticationRequest(SAMLMessageContext context, WebSSOProfileOptions options) throws SAMLException, MetadataProviderException, MessageEncodingException {
        if (!SPSSODescriptor.DEFAULT_ELEMENT_NAME.equals(context.getLocalEntityRole())) {
            throw new SAMLException("WebSSO can only be initialized for local SP, but localEntityRole is: " + context.getLocalEntityRole());
        }
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
        ExtendedMetadata idpExtendedMetadata = context.getPeerExtendedMetadata();
        if (spDescriptor == null || idpssoDescriptor == null || idpExtendedMetadata == null) {
            throw new SAMLException("SPSSODescriptor, IDPSSODescriptor or IDPExtendedMetadata are not present in the SAMLContext");
        }
        SingleSignOnService ssoService = this.getSingleSignOnService(options, idpssoDescriptor, spDescriptor);
        AssertionConsumerService consumerService = this.getAssertionConsumerService(options, idpssoDescriptor, spDescriptor);
        AuthnRequest authRequest = this.getAuthnRequest(context, options, consumerService, ssoService);
        context.setCommunicationProfileId(this.getProfileIdentifier());
        context.setOutboundMessage((XMLObject)authRequest);
        context.setOutboundSAMLMessage((SAMLObject)authRequest);
        context.setPeerEntityEndpoint((Endpoint)ssoService);
        context.setPeerEntityRoleMetadata((RoleDescriptor)idpssoDescriptor);
        context.setPeerExtendedMetadata(idpExtendedMetadata);
        if (options.getRelayState() != null) {
            context.setRelayState(options.getRelayState());
        }
        boolean sign = spDescriptor.isAuthnRequestsSigned() != false || idpssoDescriptor.getWantAuthnRequestsSigned() != false;
        this.sendMessage(context, sign);
        SAMLMessageStorage messageStorage = context.getMessageStorage();
        if (messageStorage != null) {
            messageStorage.storeMessage(authRequest.getID(), (XMLObject)authRequest);
        }
    }

    protected SingleSignOnService getSingleSignOnService(WebSSOProfileOptions options, IDPSSODescriptor idpssoDescriptor, SPSSODescriptor spDescriptor) throws MetadataProviderException {
        String userBinding = options.getBinding();
        List services = idpssoDescriptor.getSingleSignOnServices();
        for (SingleSignOnService service : services) {
            if (!this.isEndpointSupported(service)) continue;
            if (userBinding != null) {
                if (!this.isEndpointMatching((Endpoint)service, userBinding)) continue;
                this.log.debug("Found user specified binding {}", (Object)userBinding);
                return service;
            }
            return service;
        }
        if (userBinding != null) {
            throw new MetadataProviderException("User specified binding " + userBinding + " is not supported by the IDP using profile " + this.getProfileIdentifier());
        }
        throw new MetadataProviderException("No supported binding " + userBinding + " was found for profile " + this.getProfileIdentifier());
    }

    protected AssertionConsumerService getAssertionConsumerService(WebSSOProfileOptions options, IDPSSODescriptor idpSSODescriptor, SPSSODescriptor spDescriptor) throws MetadataProviderException {
        List services = spDescriptor.getAssertionConsumerServices();
        if (options.getAssertionConsumerIndex() != null) {
            for (AssertionConsumerService service : services) {
                if (!options.getAssertionConsumerIndex().equals(service.getIndex())) continue;
                if (!this.isEndpointSupported(service)) {
                    throw new MetadataProviderException("Endpoint designated by the value in the WebSSOProfileOptions is not supported by this profile");
                }
                this.log.debug("Using consumer service determined by user preference with binding {}", (Object)service.getBinding());
                return service;
            }
            throw new MetadataProviderException("AssertionConsumerIndex " + options.getAssertionConsumerIndex() + " not found for spDescriptor " + spDescriptor);
        }
        if (spDescriptor.getDefaultAssertionConsumerService() != null && this.isEndpointSupported(spDescriptor.getDefaultAssertionConsumerService())) {
            AssertionConsumerService service = spDescriptor.getDefaultAssertionConsumerService();
            this.log.debug("Using default consumer service with binding {}", (Object)service.getBinding());
            return service;
        }
        if (services.size() > 0) {
            for (AssertionConsumerService service : services) {
                if (!this.isEndpointSupported(service)) continue;
                this.log.debug("Using first available consumer service with binding {}", (Object)service.getBinding());
                return service;
            }
        }
        throw new MetadataProviderException("Service provider has no assertion consumer service available for the selected profile " + spDescriptor);
    }

    protected boolean isEndpointSupported(SingleSignOnService endpoint) throws MetadataProviderException {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(endpoint.getBinding()) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact".equals(endpoint.getBinding()) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(endpoint.getBinding());
    }

    protected boolean isEndpointSupported(AssertionConsumerService endpoint) throws MetadataProviderException {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(endpoint.getBinding()) | "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact".equals(endpoint.getBinding());
    }

    protected AuthnRequest getAuthnRequest(SAMLMessageContext context, WebSSOProfileOptions options, AssertionConsumerService assertionConsumer, SingleSignOnService bindingService) throws SAMLException, MetadataProviderException {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        request.setIsPassive(options.getPassive());
        request.setForceAuthn(options.getForceAuthN());
        request.setProviderName(options.getProviderName());
        request.setVersion(SAMLVersion.VERSION_20);
        this.buildCommonAttributes(context.getLocalEntityId(), (RequestAbstractType)request, (Endpoint)bindingService);
        this.buildScoping(request, bindingService, options);
        this.builNameIDPolicy(request, options);
        this.buildAuthnContext(request, options);
        this.buildReturnAddress(request, assertionConsumer);
        return request;
    }

    protected void builNameIDPolicy(AuthnRequest request, WebSSOProfileOptions options) {
        if (options.getNameID() != null) {
            SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
            NameIDPolicy nameIDPolicy = (NameIDPolicy)builder.buildObject();
            nameIDPolicy.setFormat(options.getNameID());
            nameIDPolicy.setAllowCreate(options.isAllowCreate());
            nameIDPolicy.setSPNameQualifier(this.getSPNameQualifier());
            request.setNameIDPolicy(nameIDPolicy);
        }
    }

    protected String getSPNameQualifier() {
        return null;
    }

    protected void buildAuthnContext(AuthnRequest request, WebSSOProfileOptions options) {
        Collection<String> contexts = options.getAuthnContexts();
        if (contexts != null && contexts.size() > 0) {
            SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
            RequestedAuthnContext authnContext = (RequestedAuthnContext)builder.buildObject();
            authnContext.setComparison(options.getAuthnContextComparison());
            for (String context : contexts) {
                SAMLObjectBuilder contextRefBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
                AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)contextRefBuilder.buildObject();
                authnContextClassRef.setAuthnContextClassRef(context);
                authnContext.getAuthnContextClassRefs().add(authnContextClassRef);
            }
            request.setRequestedAuthnContext(authnContext);
        }
    }

    protected void buildReturnAddress(AuthnRequest request, AssertionConsumerService service) throws MetadataProviderException {
        if (service != null) {
            if (service.getResponseLocation() != null) {
                request.setAssertionConsumerServiceURL(service.getResponseLocation());
            } else {
                request.setAssertionConsumerServiceURL(service.getLocation());
            }
            request.setProtocolBinding(this.getEndpointBinding((Endpoint)service));
        }
    }

    protected void buildScoping(AuthnRequest request, SingleSignOnService serviceURI, WebSSOProfileOptions options) {
        if (options.isIncludeScoping() != null && options.isIncludeScoping().booleanValue()) {
            Set<String> idpEntityNames = options.getAllowedIDPs();
            IDPList idpList = this.buildIDPList(idpEntityNames, serviceURI);
            SAMLObjectBuilder scopingBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Scoping.DEFAULT_ELEMENT_NAME);
            Scoping scoping = (Scoping)scopingBuilder.buildObject();
            scoping.setIDPList(idpList);
            scoping.setProxyCount(options.getProxyCount());
            if (!CollectionUtils.isEmpty(options.getRequesterIds())) {
                RequesterIDBuilder requesterIDBuilder = new RequesterIDBuilder();
                for (String id : options.getRequesterIds()) {
                    RequesterID requesterID = requesterIDBuilder.buildObject();
                    requesterID.setRequesterID(id);
                    scoping.getRequesterIDs().add(requesterID);
                }
            }
            request.setScoping(scoping);
        }
    }

    protected IDPList buildIDPList(Set<String> idpEntityNames, SingleSignOnService serviceURI) {
        if (idpEntityNames == null) {
            return null;
        }
        SAMLObjectBuilder idpEntryBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(IDPList.DEFAULT_ELEMENT_NAME);
        IDPList idpList = (IDPList)idpListBuilder.buildObject();
        for (String entityID : idpEntityNames) {
            IDPEntry idpEntry = (IDPEntry)idpEntryBuilder.buildObject();
            idpEntry.setProviderID(entityID);
            idpList.getIDPEntrys().add(idpEntry);
            if (serviceURI == null) continue;
            idpEntry.setLoc(serviceURI.getLocation());
        }
        return idpList;
    }
}

