/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.processor;

import javax.servlet.http.HttpServletRequest;
import org.opensaml.liberty.binding.decoding.HTTPPAOS11Decoder;
import org.opensaml.liberty.binding.encoding.HTTPPAOS11Encoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;

public class HTTPPAOS11Binding
extends HTTPSOAP11Binding {
    public HTTPPAOS11Binding(ParserPool parserPool) {
        super((MessageDecoder)new HTTPPAOS11Decoder(parserPool), (MessageEncoder)new HTTPPAOS11Encoder());
    }

    public HTTPPAOS11Binding(MessageDecoder decoder, MessageEncoder encoder) {
        super(decoder, encoder);
    }

    @Override
    public boolean supports(InTransport transport) {
        if (transport instanceof HttpServletRequestAdapter) {
            HttpServletRequestAdapter t = (HttpServletRequestAdapter)transport;
            if (!"POST".equalsIgnoreCase(t.getHTTPMethod())) {
                return false;
            }
            HttpServletRequest request = t.getWrappedRequest();
            String contentType = request.getContentType();
            return contentType != null && contentType.startsWith("application/vnd.paos+xml");
        }
        return false;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:PAOS";
    }
}

