/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka.shell;

import com.google.common.base.Strings;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.distributed.core.api.Identity;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="opennms", name="kafka-sink-topics", description="List Sink Topics used by current system.")
@Service
public class KafkaSinkTopics
implements Action {
    @Reference
    private ConfigurationAdmin configAdmin;
    @Reference
    private Identity identity;
    @Option(name="-t", aliases={"--timeout"}, description="Connection timeout for Kafka Server")
    private int timeout;
    protected static final int DEFAULT_TIMEOUT = 5000;

    public Object execute() throws Exception {
        Properties kafkaConfig = Utils.getKafkaConfig((Identity)this.identity, (ConfigurationAdmin)this.configAdmin, (String)"Sink");
        if (kafkaConfig.isEmpty() || kafkaConfig.getProperty("bootstrap.servers") == null) {
            System.out.println("Kafka not configured for Sink");
            return null;
        }
        if (this.timeout <= 0) {
            String requestTimeoutMsConfig = kafkaConfig.getProperty("request.timeout.ms");
            this.timeout = !Strings.isNullOrEmpty((String)requestTimeoutMsConfig) ? Integer.parseInt(requestTimeoutMsConfig) : 5000;
        }
        kafkaConfig.put("request.timeout.ms", (Object)this.timeout);
        try {
            Set topics = Utils.getTopics((Properties)kafkaConfig);
            if (!topics.isEmpty()) {
                String opennmsInstance = SystemInfoUtils.getInstanceId();
                Set<String> sinkTopics = topics.stream().filter(topic -> topic.contains(opennmsInstance)).filter(topic -> topic.contains("Sink")).collect(Collectors.toSet());
                if (!sinkTopics.isEmpty()) {
                    System.out.println("\nSink topics:");
                    sinkTopics.forEach(System.out::println);
                    return null;
                }
            }
            System.out.println("No topics listed for Kafka Sink");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

