/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    private static final String LOG4J_CATEGORY = "jetty-server";
    int m_port = 8080;
    private Server m_server;

    protected JettyServer() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        File jettyXml = new File(System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "jetty.xml");
        InputStream jettyXmlStream = null;
        try {
            this.m_server = new Server();
            MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            this.m_server.addEventListener((Container.Listener)mbeanContainer);
            this.m_server.addBean((Object)mbeanContainer);
            jettyXmlStream = jettyXml.exists() ? jettyXml.toURI().toURL().openStream() : ((Object)((Object)this)).getClass().getResourceAsStream("jetty.xml");
            if (jettyXmlStream == null) {
                throw new RuntimeException("Unable to locate jetty.xml in the classpath!");
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(jettyXmlStream);
            xmlConfiguration.configure((Object)this.m_server);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        this.m_server.setStopAtShutdown(true);
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting Jetty Server", t);
            throw new IllegalStateException(t);
        }
    }

    protected void onStop() {
        try {
            this.m_server.stop();
        }
        catch (Throwable t) {
            LOG.error("Error stopping Jetty Server", t);
            throw new IllegalStateException(t);
        }
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    private static boolean isSsl(ServerConnector conn) {
        return conn.getConnectionFactory(SslConnectionFactory.class) != null;
    }

    private Stream<ServerConnector> getHttpsServerStream() {
        return Arrays.stream(this.m_server.getConnectors()).filter(conn -> conn instanceof ServerConnector).map(conn -> (ServerConnector)conn).filter(JettyServer::isSsl);
    }

    private Stream<ServerConnector> getHttpServerStream() {
        return Arrays.stream(this.m_server.getConnectors()).filter(conn -> conn instanceof ServerConnector).map(conn -> (ServerConnector)conn).filter(conn -> !JettyServer.isSsl(conn));
    }

    public long getHttpsConnectionsTotal() {
        return this.getHttpsServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnections).sum();
    }

    public long getHttpsConnectionsOpen() {
        return this.getHttpsServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnectionsOpen).sum();
    }

    public long getHttpsConnectionsOpenMax() {
        return this.getHttpsServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnectionsOpenMax).sum();
    }

    public long getHttpConnectionsTotal() {
        return this.getHttpServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnections).sum();
    }

    public long getHttpConnectionsOpen() {
        return this.getHttpServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnectionsOpen).sum();
    }

    public long getHttpConnectionsOpenMax() {
        return this.getHttpServerStream().map(conn -> (ConnectorStatistics)conn.getBean(ConnectorStatistics.class)).mapToLong(ConnectorStatistics::getConnectionsOpenMax).sum();
    }
}

