/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.IOException;
import java.util.List;
import org.jolokia.config.ConfigKey;
import org.jolokia.discovery.AbstractDiscoveryMessage;
import org.jolokia.discovery.DiscoveryIncomingMessage;
import org.jolokia.discovery.DiscoveryOutgoingMessage;
import org.jolokia.discovery.JolokiaDiscoveryMBean;
import org.jolokia.discovery.MulticastUtil;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONArray;

public class JolokiaDiscovery
implements JolokiaDiscoveryMBean {
    private final String agentId;
    private final LogHandler logHandler;

    public JolokiaDiscovery(String pAgentId, LogHandler pLogHandler) {
        this.agentId = pAgentId;
        this.logHandler = pLogHandler;
    }

    @Override
    public List lookupAgents() throws IOException {
        return this.lookupAgentsWithTimeout(1000);
    }

    @Override
    public List lookupAgentsWithTimeout(int pTimeout) throws IOException {
        return this.lookupAgentsWithTimeoutAndMulticastAddress(1000, ConfigKey.MULTICAST_GROUP.getDefaultValue(), Integer.parseInt(ConfigKey.MULTICAST_PORT.getDefaultValue()));
    }

    @Override
    public List lookupAgentsWithTimeoutAndMulticastAddress(int pTimeout, String pMulticastGroup, int pMulticastPort) throws IOException {
        DiscoveryOutgoingMessage out = new DiscoveryOutgoingMessage.Builder(AbstractDiscoveryMessage.MessageType.QUERY).agentId(this.agentId).build();
        List<DiscoveryIncomingMessage> discovered = MulticastUtil.sendQueryAndCollectAnswers(out, pTimeout, pMulticastGroup, pMulticastPort, this.logHandler);
        JSONArray ret = new JSONArray();
        for (DiscoveryIncomingMessage in : discovered) {
            ret.add(in.getAgentDetails().toJSONObject());
        }
        return ret;
    }
}

