/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsSendTimedOutException;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.jms.provider.amqp.AmqpTransferTagGenerator;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpFixedProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpFixedProducer.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final AmqpTransferTagGenerator tagGenerator = new AmqpTransferTagGenerator(true);
    private final Map<Object, InFlightSend> sent = new LinkedHashMap<Object, InFlightSend>();
    private final Map<Object, InFlightSend> blocked = new LinkedHashMap<Object, InFlightSend>();
    private AsyncResult sendCompletionWatcher;
    private final AmqpConnection connection;

    public AmqpFixedProducer(AmqpSession session, JmsProducerInfo info, Sender sender) {
        super(session, info, sender);
        this.connection = session.getConnection();
        this.delayedDeliverySupported = this.connection.getProperties().isDelayedDeliverySupported();
    }

    @Override
    public void close(AsyncResult request) {
        if (!this.blocked.isEmpty() || !this.sent.isEmpty()) {
            this.closeRequest = request;
            return;
        }
        super.close(request);
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        if (this.isClosed()) {
            request.onFailure(new IllegalStateException("The MessageProducer is closed"));
        }
        if (!this.delayedDeliverySupported && envelope.getMessage().getFacade().isDeliveryTimeTransmitted()) {
            request.onFailure(new JMSException("Remote does not support delayed message delivery"));
        } else if (((Sender)this.getEndpoint()).getCredit() <= 0) {
            LOG.trace("Holding Message send until credit is available.");
            InFlightSend send = new InFlightSend(envelope, request);
            if (this.getSendTimeout() > -1L) {
                send.requestTimeout = this.getParent().getProvider().scheduleRequestTimeout((AsyncResult)send, this.getSendTimeout(), send);
            }
            this.blocked.put(envelope.getMessageId(), send);
            this.getParent().getProvider().pumpToProtonTransport(request);
        } else {
            this.doSend(envelope, request);
        }
    }

    private void doSend(JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        if (this.session.isTransacted() && this.session.isTransactionFailed()) {
            request.onSuccess();
            return;
        }
        LOG.trace("Producer sending message: {}", (Object)envelope);
        boolean presettle = envelope.isPresettle() || this.isPresettle();
        Delivery delivery = null;
        if (presettle) {
            delivery = ((Sender)this.getEndpoint()).delivery(EMPTY_BYTE_ARRAY, 0, 0);
        } else {
            byte[] tag = this.tagGenerator.getNextTag();
            delivery = ((Sender)this.getEndpoint()).delivery(tag, 0, tag.length);
        }
        if (this.session.isTransacted()) {
            AmqpTransactionContext context = this.session.getTransactionContext();
            delivery.disposition((DeliveryState)context.getTxnEnrolledState());
            context.registerTxProducer(this);
        }
        ByteBuf encoded = (ByteBuf)envelope.getPayload();
        ((Sender)this.getEndpoint()).send(encoded.array(), encoded.arrayOffset() + encoded.readerIndex(), encoded.readableBytes());
        AmqpProvider provider = this.getParent().getProvider();
        InFlightSend send = null;
        if (request instanceof InFlightSend) {
            send = (InFlightSend)request;
        } else {
            send = new InFlightSend(envelope, request);
            if (!presettle && this.getSendTimeout() != -1L) {
                send.requestTimeout = this.getParent().getProvider().scheduleRequestTimeout((AsyncResult)send, this.getSendTimeout(), send);
            }
        }
        if (presettle) {
            delivery.settle();
        } else {
            this.sent.put(envelope.getMessageId(), send);
            ((Sender)this.getEndpoint()).advance();
        }
        send.setDelivery(delivery);
        delivery.setContext((Object)send);
        if (provider.pumpToProtonTransport(request)) {
            if (presettle) {
                send.onSuccess();
            } else if (envelope.isSendAsync()) {
                send.getOriginalRequest().onSuccess();
            }
        }
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
        if (!this.blocked.isEmpty() && ((Sender)this.getEndpoint()).getCredit() > 0) {
            Iterator<InFlightSend> blockedSends = this.blocked.values().iterator();
            while (((Sender)this.getEndpoint()).getCredit() > 0 && blockedSends.hasNext()) {
                LOG.trace("Dispatching previously held send");
                InFlightSend held = blockedSends.next();
                try {
                    this.doSend(held.getEnvelope(), held);
                }
                catch (JMSException e) {
                    throw IOExceptionSupport.create(e);
                }
                finally {
                    blockedSends.remove();
                }
            }
        }
        if (((Sender)this.getEndpoint()).getDrain()) {
            ((Sender)this.getEndpoint()).drained();
        }
        super.processFlowUpdates(provider);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws IOException {
        DeliveryState state = delivery.getRemoteState();
        if (state != null) {
            InFlightSend send = (InFlightSend)delivery.getContext();
            if (state instanceof Accepted) {
                LOG.trace("Outcome of delivery was accepted: {}", (Object)delivery);
                send.onSuccess();
                super.processDeliveryUpdates(provider, delivery);
                return;
            }
            Throwable deliveryError = null;
            Outcome outcome = null;
            if (state instanceof TransactionalState) {
                LOG.trace("State of delivery is Transactional, retrieving outcome: {}", (Object)state);
                outcome = ((TransactionalState)state).getOutcome();
            } else if (state instanceof Outcome) {
                outcome = (Outcome)state;
            } else {
                LOG.warn("Message send updated with unsupported state: {}", (Object)state);
                outcome = null;
            }
            if (outcome instanceof Accepted) {
                LOG.trace("Outcome of delivery was accepted: {}", (Object)delivery);
                send.onSuccess();
            } else if (outcome instanceof Rejected) {
                LOG.trace("Outcome of delivery was rejected: {}", (Object)delivery);
                ErrorCondition remoteError = ((Rejected)outcome).getError();
                if (remoteError == null) {
                    remoteError = ((Sender)this.getEndpoint()).getRemoteCondition();
                }
                deliveryError = AmqpSupport.convertToException(this.getParent().getProvider(), this.getEndpoint(), remoteError);
            } else if (outcome instanceof Released) {
                LOG.trace("Outcome of delivery was released: {}", (Object)delivery);
                deliveryError = new JMSException("Delivery failed: released by receiver");
            } else if (outcome instanceof Modified) {
                LOG.trace("Outcome of delivery was modified: {}", (Object)delivery);
                deliveryError = new JMSException("Delivery failed: failure at remote");
            }
            if (deliveryError != null) {
                send.onFailure(deliveryError);
            }
        }
        super.processDeliveryUpdates(provider, delivery);
    }

    public AmqpSession getSession() {
        return this.session;
    }

    @Override
    public boolean isAnonymous() {
        return ((JmsProducerInfo)this.getResourceInfo()).getDestination() == null;
    }

    @Override
    public boolean isPresettle() {
        return ((Sender)this.getEndpoint()).getSenderSettleMode() == SenderSettleMode.SETTLED;
    }

    public long getSendTimeout() {
        return this.getParent().getProvider().getSendTimeout();
    }

    public String toString() {
        return "AmqpFixedProducer { " + this.getProducerId() + " }";
    }

    @Override
    public void handleResourceClosure(AmqpProvider provider, Throwable error) {
        if (error == null) {
            error = new JMSException("Producer closed remotely before message transfer result was notified");
        }
        ArrayList<InFlightSend> inflightSends = new ArrayList<InFlightSend>(this.sent.values());
        for (InFlightSend send : inflightSends) {
            try {
                send.onFailure(error);
            }
            catch (Exception e) {
                LOG.debug("Caught exception when failing pending send during remote producer closure: {}", (Object)send, (Object)e);
            }
        }
        ArrayList<InFlightSend> blockedSends = new ArrayList<InFlightSend>(this.blocked.values());
        for (InFlightSend send : blockedSends) {
            try {
                send.onFailure(error);
            }
            catch (Exception e) {
                LOG.debug("Caught exception when failing blocked send during remote producer closure: {}", (Object)send, (Object)e);
            }
        }
    }

    private class InFlightSend
    implements AsyncResult,
    AmqpExceptionBuilder {
        private final JmsOutboundMessageDispatch envelope;
        private final AsyncResult request;
        private Delivery delivery;
        private ScheduledFuture<?> requestTimeout;

        public InFlightSend(JmsOutboundMessageDispatch envelope, AsyncResult request) {
            this.envelope = envelope;
            this.request = request;
        }

        @Override
        public void onFailure(Throwable cause) {
            this.handleSendCompletion(false);
            if (this.request.isComplete()) {
                if (this.envelope.isCompletionRequired()) {
                    AmqpFixedProducer.this.getParent().getProvider().getProviderListener().onFailedMessageSend(this.envelope, cause);
                } else {
                    AmqpFixedProducer.this.getParent().getProvider().fireNonFatalProviderException(IOExceptionSupport.create(cause));
                }
            } else {
                this.request.onFailure(cause);
            }
        }

        @Override
        public void onSuccess() {
            this.handleSendCompletion(true);
            if (!this.request.isComplete()) {
                this.request.onSuccess();
            }
            if (this.envelope.isCompletionRequired()) {
                AmqpFixedProducer.this.getParent().getProvider().getProviderListener().onCompletedMessageSend(this.envelope);
            }
        }

        public void setRequestTimeout(ScheduledFuture<?> requestTimeout) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel(false);
            }
            this.requestTimeout = requestTimeout;
        }

        public JmsOutboundMessageDispatch getEnvelope() {
            return this.envelope;
        }

        public AsyncResult getOriginalRequest() {
            return this.request;
        }

        public void setDelivery(Delivery delivery) {
            this.delivery = delivery;
        }

        public Delivery getDelivery() {
            return this.delivery;
        }

        @Override
        public boolean isComplete() {
            return this.request.isComplete();
        }

        private void handleSendCompletion(boolean successful) {
            this.setRequestTimeout(null);
            if (this.getDelivery() != null) {
                AmqpFixedProducer.this.sent.remove(this.envelope.getMessageId());
                this.delivery.settle();
                AmqpFixedProducer.this.tagGenerator.returnTag(this.delivery.getTag());
            } else {
                AmqpFixedProducer.this.blocked.remove(this.envelope.getMessageId());
            }
            this.envelope.getMessage().onSendComplete();
            if (AmqpFixedProducer.this.sendCompletionWatcher != null && AmqpFixedProducer.this.sent.isEmpty() && AmqpFixedProducer.this.blocked.isEmpty()) {
                AmqpFixedProducer.this.sendCompletionWatcher.onSuccess();
                AmqpFixedProducer.this.sendCompletionWatcher = null;
            }
            if (AmqpFixedProducer.this.isAwaitingClose() && !AmqpFixedProducer.this.isClosed() && AmqpFixedProducer.this.blocked.isEmpty() && AmqpFixedProducer.this.sent.isEmpty()) {
                AmqpFixedProducer.super.close(AmqpFixedProducer.this.closeRequest);
            }
        }

        @Override
        public Exception createException() {
            if (this.delivery == null) {
                return new JmsSendTimedOutException("Timed out waiting for credit to send Message", this.envelope.getMessage());
            }
            return new JmsSendTimedOutException("Timed out waiting for disposition of sent Message", this.envelope.getMessage());
        }
    }
}

