/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.Geolocation;
import org.opennms.integration.api.v1.model.NodeAssetRecord;
import org.opennms.integration.api.v1.model.immutables.ImmutableGeolocation;

public final class ImmutableNodeAssetRecord
implements NodeAssetRecord {
    private final String vendor;
    private final String modelNumber;
    private final String description;
    private final String assetNumber;
    private final String operatingSystem;
    private final String region;
    private final String division;
    private final String department;
    private final String building;
    private final String floor;
    private final Geolocation geolocation;

    private ImmutableNodeAssetRecord(Builder builder) {
        this.vendor = builder.vendor;
        this.modelNumber = builder.modelNumber;
        this.description = builder.description;
        this.assetNumber = builder.assetNumber;
        this.operatingSystem = builder.operatingSystem;
        this.region = builder.region;
        this.division = builder.division;
        this.department = builder.department;
        this.building = builder.building;
        this.floor = builder.floor;
        this.geolocation = ImmutableGeolocation.immutableCopy(builder.geolocation);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(NodeAssetRecord fromNodeAssetRecord) {
        return new Builder(fromNodeAssetRecord);
    }

    public static NodeAssetRecord immutableCopy(NodeAssetRecord nodeAssetRecord) {
        if (nodeAssetRecord == null || nodeAssetRecord instanceof ImmutableNodeAssetRecord) {
            return nodeAssetRecord;
        }
        return ImmutableNodeAssetRecord.newBuilderFrom(nodeAssetRecord).build();
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAssetNumber() {
        return this.assetNumber;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDivision() {
        return this.division;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getBuilding() {
        return this.building;
    }

    public String getFloor() {
        return this.floor;
    }

    public Geolocation getGeolocation() {
        return this.geolocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNodeAssetRecord that = (ImmutableNodeAssetRecord)o;
        return Objects.equals(this.vendor, that.vendor) && Objects.equals(this.modelNumber, that.modelNumber) && Objects.equals(this.description, that.description) && Objects.equals(this.assetNumber, that.assetNumber) && Objects.equals(this.operatingSystem, that.operatingSystem) && Objects.equals(this.region, that.region) && Objects.equals(this.division, that.division) && Objects.equals(this.department, that.department) && Objects.equals(this.building, that.building) && Objects.equals(this.floor, that.floor) && Objects.equals(this.geolocation, that.geolocation);
    }

    public int hashCode() {
        return Objects.hash(this.vendor, this.modelNumber, this.description, this.assetNumber, this.operatingSystem, this.region, this.division, this.department, this.building, this.floor, this.geolocation);
    }

    public String toString() {
        return "ImmutableNodeAssetRecord{vendor='" + this.vendor + "', modelNumber='" + this.modelNumber + "', description='" + this.description + "', assetNumber='" + this.assetNumber + "', operatingSystem='" + this.operatingSystem + "', region='" + this.region + "', division='" + this.division + "', department='" + this.department + "', building='" + this.building + "', floor='" + this.floor + "', geolocation=" + this.geolocation + "}";
    }

    public static final class Builder {
        private String vendor;
        private String modelNumber;
        private String description;
        private String assetNumber;
        private String operatingSystem;
        private String region;
        private String division;
        private String department;
        private String building;
        private String floor;
        private Geolocation geolocation;

        private Builder() {
        }

        private Builder(NodeAssetRecord nodeAssetRecord) {
            this.vendor = nodeAssetRecord.getVendor();
            this.modelNumber = nodeAssetRecord.getModelNumber();
            this.description = nodeAssetRecord.getDescription();
            this.assetNumber = nodeAssetRecord.getAssetNumber();
            this.operatingSystem = nodeAssetRecord.getOperatingSystem();
            this.region = nodeAssetRecord.getRegion();
            this.division = nodeAssetRecord.getDivision();
            this.department = nodeAssetRecord.getDepartment();
            this.building = nodeAssetRecord.getBuilding();
            this.floor = nodeAssetRecord.getFloor();
            this.geolocation = nodeAssetRecord.getGeolocation();
        }

        public Builder setVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder setModelNumber(String modelNumber) {
            this.modelNumber = modelNumber;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAssetNumber(String assetNumber) {
            this.assetNumber = assetNumber;
            return this;
        }

        public Builder setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setDivision(String division) {
            this.division = division;
            return this;
        }

        public Builder setDepartment(String department) {
            this.department = department;
            return this;
        }

        public Builder setBuilding(String building) {
            this.building = building;
            return this;
        }

        public Builder setFloor(String floor) {
            this.floor = floor;
            return this;
        }

        public Builder setGeolocation(Geolocation geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public ImmutableNodeAssetRecord build() {
            return new ImmutableNodeAssetRecord(this);
        }
    }
}

