/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Timestamp;

public class Results<T extends Element<?>>
implements Iterable<Row<T>>,
Serializable {
    private static final long serialVersionUID = -3273508775312254315L;
    Map<Timestamp, Row<T>> m_rows = Maps.newTreeMap();

    public void addElement(T sample) {
        Row<T> row = this.m_rows.get(sample.getTimestamp());
        if (row == null) {
            row = new Row(sample.getTimestamp(), sample.getResource());
            this.addRow(row);
        }
        row.addElement(sample);
    }

    public void addRow(Row<T> row) {
        this.m_rows.put(row.getTimestamp(), row);
    }

    public Collection<Row<T>> getRows() {
        return this.m_rows.values();
    }

    @Override
    public Iterator<Row<T>> iterator() {
        return this.getRows().iterator();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getRows());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Results other = (Results)obj;
        return Objects.equal(this.m_rows, other.m_rows);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_rows});
    }

    public static class Row<T extends Element<?>>
    implements Iterable<T>,
    Serializable {
        private static final long serialVersionUID = 4284597337435202235L;
        private Timestamp m_timestamp;
        private Resource m_resource;
        private Map<String, T> m_cells = Maps.newHashMap();

        public Row(Timestamp timestamp, Resource resource) {
            this.m_timestamp = timestamp;
            this.m_resource = resource;
        }

        public void addElement(T sample) {
            this.m_cells.put(sample.getName(), sample);
        }

        public T getElement(String name) {
            return (T)((Element)this.m_cells.get(name));
        }

        public Timestamp getTimestamp() {
            return this.m_timestamp;
        }

        public Resource getResource() {
            return this.m_resource;
        }

        public Collection<T> getElements() {
            return this.m_cells.values();
        }

        @Override
        public Iterator<T> iterator() {
            return this.getElements().iterator();
        }

        public String toString() {
            return String.format("%s[timestamp=%s, resource=%s, elements=%s", this.getClass().getSimpleName(), this.getTimestamp(), this.getResource(), this.getElements());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Row other = (Row)obj;
            return Objects.equal((Object)this.m_timestamp, (Object)other.m_timestamp) && Objects.equal((Object)this.m_resource, (Object)other.m_resource) && Objects.equal(this.m_cells, other.m_cells);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.m_timestamp, this.m_resource, this.m_cells});
        }
    }
}

