/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ExponentialPropagationEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.HighestSeverityAboveEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.HighestSeverityEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ReductionFunctionEntityVisitor;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ThresholdEntity;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ExponentialPropagation;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverity;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverityAbove;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.Threshold;

public class ReduceFunctionMapper {
    private static final ReduceFunctionVisitor<AbstractReductionFunctionEntity> serviceToPersistenceMapping = new ReduceFunctionVisitor<AbstractReductionFunctionEntity>(){

        public AbstractReductionFunctionEntity visit(HighestSeverity highestSeverity) {
            return new HighestSeverityEntity();
        }

        public AbstractReductionFunctionEntity visit(HighestSeverityAbove highestSeverityAbove) {
            HighestSeverityAboveEntity entity = new HighestSeverityAboveEntity();
            entity.setThreshold(highestSeverityAbove.getThreshold().ordinal());
            return entity;
        }

        public AbstractReductionFunctionEntity visit(Threshold threshold) {
            ThresholdEntity entity = new ThresholdEntity();
            entity.setThreshold(threshold.getThreshold());
            return entity;
        }

        public AbstractReductionFunctionEntity visit(ExponentialPropagation exponentialPropagation) {
            ExponentialPropagationEntity entity = new ExponentialPropagationEntity();
            entity.setBase(exponentialPropagation.getBase());
            return entity;
        }
    };
    private static final ReductionFunctionEntityVisitor<ReductionFunction> persistenceToServiceMapping = new ReductionFunctionEntityVisitor<ReductionFunction>(){

        public ReductionFunction visit(HighestSeverityAboveEntity highestSeverityAboveEntity) {
            HighestSeverityAbove result = new HighestSeverityAbove();
            result.setThreshold(Status.get((int)highestSeverityAboveEntity.getThreshold()));
            return result;
        }

        public ReductionFunction visit(HighestSeverityEntity highestSeverityEntity) {
            return new HighestSeverity();
        }

        public ReductionFunction visit(ThresholdEntity thresholdEntity) {
            Threshold result = new Threshold();
            result.setThreshold(thresholdEntity.getThreshold());
            return result;
        }

        public ReductionFunction visit(ExponentialPropagationEntity exponentialPropagationEntity) {
            ExponentialPropagation result = new ExponentialPropagation();
            result.setBase(exponentialPropagationEntity.getBase());
            return result;
        }
    };

    public ReductionFunction toServiceFunction(AbstractReductionFunctionEntity reductionFunctionEntity) {
        if (reductionFunctionEntity == null) {
            return null;
        }
        ReductionFunction reductionFunction = (ReductionFunction)reductionFunctionEntity.accept(persistenceToServiceMapping);
        if (reductionFunction == null) {
            throw new IllegalArgumentException("No mapping found");
        }
        return reductionFunction;
    }

    public AbstractReductionFunctionEntity toPersistenceFunction(ReductionFunction reductionFunction) {
        AbstractReductionFunctionEntity functionEntity = (AbstractReductionFunctionEntity)reductionFunction.accept(serviceToPersistenceMapping);
        if (functionEntity == null) {
            throw new IllegalArgumentException("No mapping found");
        }
        return functionEntity;
    }
}

