/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.JerseyContextFactory;
import com.eclipsesource.jaxrs.publisher.ServletConfiguration;
import com.eclipsesource.jaxrs.publisher.api.AnnotationUtils;
import com.eclipsesource.jaxrs.publisher.api.ApplicationDTO;
import com.eclipsesource.jaxrs.publisher.api.ApplicationRegistry;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.JerseyContext;
import com.eclipsesource.jaxrs.publisher.internal.JerseyContextConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.RootApplication;
import com.eclipsesource.jaxrs.publisher.internal.ServiceContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

public class ApplicationRegistryImpl
implements ApplicationRegistry {
    private final BundleContext bundleContext;
    private final Map<HttpService, Map<String, JerseyContext>> contextMap = new HashMap<HttpService, Map<String, JerseyContext>>();
    private final List<Object> featureProviderList = new ArrayList<Object>();
    private final JerseyContextFactory jerseyContextFactory;
    private Configuration configuration;

    public ApplicationRegistryImpl(Configuration configuration, BundleContext bundleContext, JerseyContextFactory jerseyContextFactory) {
        this.configuration = Objects.requireNonNull(configuration);
        this.bundleContext = Objects.requireNonNull(bundleContext);
        this.jerseyContextFactory = Objects.requireNonNull(jerseyContextFactory);
    }

    public void addResource(HttpService httpService, Object service, Map<String, String> properties) {
        if (ApplicationRegistryImpl.isFeatureOrProvider(service)) {
            this.featureProviderList.add(service);
            this.contextMap.values().stream().flatMap(value -> value.values().stream()).forEach(context -> context.addResource(service));
        } else {
            String location = this.getApplicationPath(properties);
            JerseyContext context2 = this.getContext(httpService, location);
            if (context2 == null) {
                this.contextMap.putIfAbsent(httpService, new HashMap());
                this.contextMap.get(httpService).put(location, this.jerseyContextFactory.createJerseyContext(this.bundleContext, httpService, new JerseyContextConfiguration().withPublishDelay(this.configuration.getPublishDelay()).withRootPath(location)));
                context2 = this.contextMap.get(httpService).get(location);
                this.addFeatureAndProvider(context2);
            }
            context2.addResource(service);
        }
    }

    public List<String> getEndpoints() {
        List<String> endpoints = this.contextMap.values().stream().flatMap(entry -> entry.entrySet().stream()).flatMap(e -> {
            String servletPath = !((String)e.getKey()).endsWith("/") ? (String)e.getKey() + "/" : (String)e.getKey();
            return ((JerseyContext)e.getValue()).getRootApplication().getResources().stream().filter(resource -> AnnotationUtils.hasAnnotation((Object)resource, Path.class)).map(resource -> ((Path)AnnotationUtils.getAnnotation((Object)resource, Path.class)).value()).filter(path -> path != null && !path.trim().isEmpty()).map(path -> path.startsWith("/") ? path.substring(1, path.length()) : path).map(path -> servletPath + path);
        }).collect(Collectors.toList());
        return endpoints;
    }

    public List<String> getRootPaths() {
        return this.contextMap.values().stream().flatMap(v -> v.keySet().stream()).collect(Collectors.toList());
    }

    public List<ApplicationDTO> getAllApplications() {
        return this.contextMap.values().stream().flatMap(v -> v.entrySet().stream()).map(e -> {
            String context = (String)e.getKey();
            RootApplication rootApplication = ((JerseyContext)e.getValue()).getRootApplication();
            ApplicationDTO dto = new ApplicationDTO(context);
            dto.setResources(rootApplication.getResources());
            dto.setProperties(rootApplication.getProperties());
            return dto;
        }).collect(Collectors.toList());
    }

    public boolean isApplicationReady(String context) {
        if (this.contextMap.isEmpty()) {
            return false;
        }
        return this.contextMap.values().stream().map(v -> (JerseyContext)v.get(context)).filter(c -> c != null).map(c -> c.isApplicationReady()).reduce((ready, ready2) -> ready != false && ready2 != false).get();
    }

    private JerseyContext getContext(HttpService httpService, String location) {
        if (this.contextMap.get(httpService) != null && this.contextMap.get(httpService).get(location) != null) {
            return this.contextMap.get(httpService).get(location);
        }
        return null;
    }

    private String getApplicationPath(Map<String, String> properties) {
        String applicationPath = properties.getOrDefault("application-path", this.configuration.getDefaultRootPath());
        return ApplicationRegistryImpl.prependSlashIfMissing(applicationPath);
    }

    public void removeResource(HttpService httpService, Object resource, Map<String, String> properties) {
        if (ApplicationRegistryImpl.isFeatureOrProvider(resource)) {
            this.featureProviderList.remove(resource);
            this.contextMap.values().stream().flatMap(value -> value.values().stream()).forEach(c -> c.removeResource(resource));
        } else {
            String applicationPath = this.getApplicationPath(properties);
            JerseyContext jerseyContext = this.getContext(httpService, applicationPath);
            if (jerseyContext != null) {
                jerseyContext.removeResource(resource);
            }
        }
    }

    public List<JerseyContext> removeHttpService(HttpService service) {
        Map<String, JerseyContext> remove = this.contextMap.remove(service);
        if (remove != null) {
            return new ArrayList<JerseyContext>(remove.values());
        }
        return new ArrayList<JerseyContext>();
    }

    public void updateServletConfiguration(HttpService httpService, ServletConfiguration servletConfiguration) {
        if (this.contextMap.get(httpService) != null) {
            this.contextMap.get(httpService).values().forEach(context -> context.updateServletConfiguration(servletConfiguration));
        }
    }

    public void updateAppConfiguration(HttpService httpService, ServiceContainer applicationConfigurations) {
        if (this.contextMap.get(httpService) != null) {
            this.contextMap.get(httpService).values().forEach(context -> context.updateAppConfiguration(applicationConfigurations));
        }
    }

    public void updateConfiguration(HttpService httpService, Configuration configuration) {
        JerseyContext context;
        if (!this.configuration.getDefaultRootPath().equals(configuration.getDefaultRootPath()) && (context = this.getContext(httpService, this.configuration.getDefaultRootPath())) != null) {
            JerseyContextConfiguration newConfiguration = new JerseyContextConfiguration().withPublishDelay(configuration.getPublishDelay()).withRootPath(configuration.getDefaultRootPath());
            context.updateConfiguration(newConfiguration);
        }
        this.contextMap.values().stream().flatMap(map -> map.entrySet().stream()).forEach(entry -> {
            JerseyContextConfiguration newConfiguration = new JerseyContextConfiguration().withPublishDelay(configuration.getPublishDelay()).withRootPath((String)entry.getKey());
            ((JerseyContext)entry.getValue()).updateConfiguration(newConfiguration);
        });
        this.configuration = configuration;
    }

    private void addFeatureAndProvider(JerseyContext context) {
        this.featureProviderList.forEach(resource -> context.addResource(resource));
    }

    private static String prependSlashIfMissing(String applicationPath) {
        if (!applicationPath.startsWith("/")) {
            return "/" + applicationPath;
        }
        return applicationPath;
    }

    private static boolean isFeatureOrProvider(Object service) {
        return AnnotationUtils.hasAnnotation((Object)service, Provider.class) || service instanceof Feature;
    }
}

