/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.osgi;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.httplite.osgi.HttpServiceFactoryImpl;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.server.Server;
import org.apache.felix.httplite.servlet.HttpConstants;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String FELIX_LOG_LEVEL = "felix.log.level";
    private ServiceRegistration m_httpServiceReg;
    private Server m_server;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;

    public void start(BundleContext context) throws Exception {
        Logger logger = this.createLogger(context);
        if (context.getProperty(FELIX_LOG_LEVEL) != null) {
            logger.setLogLevel(Integer.parseInt(context.getProperty(FELIX_LOG_LEVEL)));
        }
        if (Activator.isPropertyTrue(context, "org.apache.felix.http.enable", true)) {
            Map config = this.createConfigMap(context);
            this.m_server = new Server(config, logger);
            this.m_httpServiceReg = context.registerService((class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = Activator.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), (Object)new HttpServiceFactoryImpl(logger, this.m_server), this.createHttpServiceProperties(Server.getConfiguredPort(config)));
        }
        if (Activator.isPropertyTrue(context, "org.apache.felix.https.enable", false)) {
            logger.log(2, "org.apache.felix.https.enable is not implemented in this http service.");
        }
    }

    private Dictionary createHttpServiceProperties(int port) {
        Properties props = new Properties();
        ((Dictionary)props).put(HttpConstants.SERVICE_PROPERTY_KEY_HTTP_ENABLE, "true");
        ((Dictionary)props).put(HttpConstants.SERVICE_PROPERTY_KEY_HTTPS_ENABLE, "false");
        ((Dictionary)props).put(HttpConstants.SERVICE_PROPERTY_KEY_HTTP_PORT, Integer.toString(port));
        return props;
    }

    private Map createConfigMap(BundleContext context) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.osgi.service.http.port", context.getProperty("org.osgi.service.http.port"));
        config.put("org.apache.felix.http.host", context.getProperty("org.apache.felix.http.host"));
        config.put("org.apache.felix.http.enable", context.getProperty("org.apache.felix.http.enable"));
        config.put("org.apache.felix.https.enable", context.getProperty("org.apache.felix.https.enable"));
        config.put("org.apache.felix.http.threadpool.limit", context.getProperty("org.apache.felix.http.threadpool.limit"));
        config.put("org.apache.felix.http.threadpool.timeout", context.getProperty("org.apache.felix.http.threadpool.timeout"));
        config.put("org.apache.felix.http.connection.requestlimit", context.getProperty("org.apache.felix.http.connection.requestlimit"));
        config.put("org.apache.felix.http.connection.timeout", context.getProperty("org.apache.felix.http.connection.timeout"));
        return config;
    }

    private Logger createLogger(BundleContext context) {
        Logger logger = new Logger();
        logger.setSystemBundleContext(context);
        return logger;
    }

    public void stop(BundleContext context) throws Exception {
        this.m_server.setStopping();
        if (this.m_httpServiceReg != null) {
            this.m_httpServiceReg.unregister();
        }
        if (this.m_server.getState() == 1) {
            this.m_server.stop();
        }
    }

    private static boolean isPropertyTrue(BundleContext context, String name, boolean defaultValue) {
        String value = context.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

