/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareTopologyProvider
extends AbstractTopologyProvider {
    public static final String TOPOLOGY_NAMESPACE_VMWARE = "vmware";
    private static final Logger LOG = LoggerFactory.getLogger(VmwareTopologyProvider.class);
    private static final String SPLIT_REGEXP = " *, *";
    private final NodeDao m_nodeDao;
    private final IpInterfaceDao m_ipInterfaceDao;
    public static final String METADATA_CONTEXT = "VMware";
    public static final String METADATA_MANAGEMENT_SERVER = "managementServer";
    public static final String METADATA_MANAGED_ENTITY_TYPE = "managedEntityType";
    public static final String METADATA_MANAGED_OBJECT_ID = "managedObjectId";
    public static final String METADATA_TOPOLOGY_INFO = "topologyInfo";
    public static final String METADATA_STATE = "state";

    public VmwareTopologyProvider(NodeDao nodeDao, IpInterfaceDao ipInterfaceDao) {
        super(TOPOLOGY_NAMESPACE_VMWARE);
        this.m_nodeDao = Objects.requireNonNull(nodeDao);
        this.m_ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
    }

    public void refresh() {
        this.graph.resetContainer();
        this.getEntities("HostSystem").stream().forEach(this::addHostSystem);
        this.getEntities("VirtualMachine").stream().forEach(this::addVirtualMachine);
    }

    private List<OnmsNode> getEntities(String entityType) {
        List entities = this.m_nodeDao.findNodeWithMetaData(METADATA_CONTEXT, METADATA_MANAGED_ENTITY_TYPE, entityType);
        if (entities.isEmpty()) {
            LOG.info("No entities of type '{}' with defined VMware metadata fields found!", (Object)entityType);
        }
        return entities;
    }

    public Defaults getDefaults() {
        return new Defaults().withCriteria(() -> {
            if (this.graph.getVertices(new Criteria[0]).isEmpty()) {
                return Lists.newArrayList();
            }
            return this.graph.getVertices(new Criteria[0]).stream().filter(e -> "vmware.DATACENTER_ICON".equals(e.getIconKey())).map(DefaultVertexHopCriteria::new).collect(Collectors.toList());
        });
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return VmwareTopologyProvider.getSelection((String)TOPOLOGY_NAMESPACE_VMWARE, selectedVertices, (ContentType)type);
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }

    private AbstractVertex createEntityVertex(String vertexId, String vertexName, String iconKey) {
        if (this.graph.containsVertexId(vertexId)) {
            return (AbstractVertex)this.graph.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = new AbstractVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId, vertexName);
        vertex.setIconKey(iconKey);
        return vertex;
    }

    private AbstractVertex createDatacenterVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.DATACENTER_ICON");
    }

    private AbstractVertex createNetworkVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.NETWORK_ICON");
    }

    private AbstractVertex createDatastoreVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.DATASTORE_ICON");
    }

    private AbstractVertex createVirtualMachineVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        AbstractVertex vertex = "poweredOn".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_ON") : ("poweredOff".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_OFF") : ("suspended".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_SUSPENDED") : this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_UNKNOWN")));
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private AbstractVertex createHostSystemVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        AbstractVertex vertex = "poweredOn".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_ON") : ("poweredOff".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_OFF") : ("standBy".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_STANDBY") : this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_UNKNOWN")));
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private Map<String, ParsedEntity> parseNodeAssets(OnmsNode onmsNode) {
        String vmwareTopologyInfo = VmwareTopologyProvider.getTopologyInfo(onmsNode);
        return Arrays.stream(vmwareTopologyInfo.split(SPLIT_REGEXP)).map(s -> s.trim()).filter(s -> !s.isEmpty()).map(x$0 -> new ParsedEntity((String)x$0)).collect(Collectors.toMap(ParsedEntity::getEntityId, Function.identity()));
    }

    private void addHostSystem(OnmsNode hostSystem) {
        String vmwareManagementServer = VmwareTopologyProvider.getManagementServer(hostSystem);
        String vmwareManagedObjectId = VmwareTopologyProvider.getManagedObjectId(hostSystem);
        String vmwareState = VmwareTopologyProvider.getState(hostSystem);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(hostSystem.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        AbstractVertex hostSystemVertex = this.createHostSystemVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, hostSystem.getLabel(), primaryInterface, hostSystem.getId(), vmwareState);
        this.graph.addVertices(new Vertex[]{hostSystemVertex});
        Map<String, ParsedEntity> parsedEntities = this.parseNodeAssets(hostSystem);
        String datacenterName = parsedEntities.values().stream().filter(e -> "datacenter".equals(e.getEntityType())).findFirst().map(e -> ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName() + " (" + vmwareManagementServer + ")").orElse("Datacenter (" + vmwareManagementServer + ")");
        AbstractVertex datacenterVertex = this.createDatacenterVertex(vmwareManagementServer, datacenterName);
        this.graph.addVertices(new Vertex[]{datacenterVertex});
        if (!hostSystemVertex.equals((Object)datacenterVertex)) {
            this.graph.connectVertices(datacenterName + "/" + vmwareManagementServer + "/" + vmwareManagedObjectId, (VertexRef)hostSystemVertex, (VertexRef)datacenterVertex);
        }
        parsedEntities.values().stream().filter(e -> "network".equals(e.getEntityType())).forEach(e -> {
            AbstractVertex networkVertex = this.createNetworkVertex(vmwareManagementServer + "/" + e.getEntityId(), ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName());
            this.graph.addVertices(new Vertex[]{networkVertex});
            this.graph.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + e.getEntityId(), (VertexRef)hostSystemVertex, (VertexRef)networkVertex);
        });
        parsedEntities.values().stream().filter(e -> "datastore".equals(e.getEntityType())).forEach(e -> {
            AbstractVertex datastoreVertex = this.createDatastoreVertex(vmwareManagementServer + "/" + e.getEntityId(), ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName());
            this.graph.addVertices(new Vertex[]{datastoreVertex});
            this.graph.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + e.getEntityId(), (VertexRef)hostSystemVertex, (VertexRef)datastoreVertex);
        });
    }

    private void addVirtualMachine(OnmsNode virtualMachine) {
        Map<String, ParsedEntity> parsedEntities;
        String vmwareHostSystemId;
        String vmwareManagementServer = VmwareTopologyProvider.getManagementServer(virtualMachine);
        String vmwareManagedObjectId = VmwareTopologyProvider.getManagedObjectId(virtualMachine);
        String vmwareState = VmwareTopologyProvider.getState(virtualMachine);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(virtualMachine.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        if ((vmwareHostSystemId = (String)(parsedEntities = this.parseNodeAssets(virtualMachine)).values().stream().filter(e -> "host".equals(e.getEntityType())).findFirst().map(ParsedEntity::getEntityId).orElse(null)) == null) {
            LOG.warn("Cannot find host system id for virtual machine {}/{}", (Object)vmwareManagementServer, (Object)vmwareManagedObjectId);
        }
        AbstractVertex virtualMachineVertex = this.createVirtualMachineVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, virtualMachine.getLabel(), primaryInterface, virtualMachine.getId(), vmwareState);
        this.graph.addVertices(new Vertex[]{virtualMachineVertex});
        if (!this.graph.containsVertexId(vmwareManagementServer + "/" + vmwareHostSystemId)) {
            LOG.warn("Cannot find associated vertex for host system {}/{}", (Object)vmwareManagementServer, (Object)vmwareHostSystemId);
        }
        this.graph.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + vmwareManagementServer + "/" + vmwareHostSystemId, (VertexRef)virtualMachineVertex, (VertexRef)this.graph.getVertex(this.getNamespace(), vmwareManagementServer + "/" + vmwareHostSystemId));
    }

    private static String getMetaData(OnmsNode node, String key) {
        Optional metaData = node.findMetaDataForContextAndKey(METADATA_CONTEXT, key);
        return metaData.map(onmsMetaData -> onmsMetaData.getValue().trim()).orElse("");
    }

    public static String getManagementServer(OnmsNode node) {
        return VmwareTopologyProvider.getMetaData(node, METADATA_MANAGEMENT_SERVER);
    }

    public static String getManagedObjectId(OnmsNode node) {
        return VmwareTopologyProvider.getMetaData(node, METADATA_MANAGED_OBJECT_ID);
    }

    public static String getManagedEntityType(OnmsNode node) {
        return VmwareTopologyProvider.getMetaData(node, METADATA_MANAGED_ENTITY_TYPE);
    }

    public static String getState(OnmsNode node) {
        return VmwareTopologyProvider.getMetaData(node, METADATA_STATE);
    }

    public static String getTopologyInfo(OnmsNode node) {
        return VmwareTopologyProvider.getMetaData(node, METADATA_TOPOLOGY_INFO);
    }

    private static interface Icons {
        public static final String DATACENTER = "vmware.DATACENTER_ICON";
        public static final String DATASTORE = "vmware.DATASTORE_ICON";
        public static final String NETWORK = "vmware.NETWORK_ICON";
        public static final String VIRTUAL_MACHINE_UNKNOWN = "vmware.VIRTUALMACHINE_ICON_UNKNOWN";
        public static final String VIRTUAL_MACHINE_ON = "vmware.VIRTUALMACHINE_ICON_ON";
        public static final String VIRTUAL_MACHINE_OFF = "vmware.VIRTUALMACHINE_ICON_OFF";
        public static final String VIRTUAL_MACHINE_SUSPENDED = "vmware.VIRTUALMACHINE_ICON_SUSPENDED";
        public static final String HOSTSYSTEM_UNKNOWN = "vmware.HOSTSYSTEM_ICON_UNKNOWN";
        public static final String HOSTSYSTEM_ON = "vmware.HOSTSYSTEM_ICON_ON";
        public static final String HOSTSYSTEM_OFF = "vmware.HOSTSYSTEM_ICON_OFF";
        public static final String HOSTSYSTEM_STANDBY = "vmware.HOSTSYSTEM_ICON_STANDBY";
    }

    private class ParsedEntity {
        private String entityId;
        private String entityName;
        private String entityType;

        public ParsedEntity(String string) {
            String[] splitBySlash = string.split("/");
            this.entityId = splitBySlash[0];
            this.entityType = this.entityId.split("-")[0];
            this.entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    this.entityName = new String(URLDecoder.decode(splitBySlash[1], StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public void setEntityType(String entityType) {
            this.entityType = entityType;
        }
    }
}

